/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.Cipher;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.cryptox.ShortBufferException;
import com.initech.provider.crypto.cipher.Wrapper;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public abstract class PaddableWrapper
extends Wrapper {
    protected byte[] bufferedData;
    protected int bufferedLength;
    protected String paddingName;
    protected int padding;
    protected static final int NoPadding = 0;
    protected static final int PKCS5Padding = 1;
    protected static final int TLSPadding = 2;
    protected final int MaximunPaddedCipherText = 256;
    protected int tlsPaddingLength = 0;
    private byte[] tempBlock = null;

    public PaddableWrapper(Cipher delegationCipher) {
        super(delegationCipher);
    }

    protected void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super._engineInit(opmode, key, params, random);
        this.tempBlock = new byte[512];
        this.bufferedData = new byte[256 + this.blockSize];
        this.bufferedLength = 0;
    }

    protected final int addToBufferedData(byte[] input, int offset, int length) {
        if (input != null && length != 0) {
            System.arraycopy(input, offset, this.bufferedData, this.bufferedLength, length);
        }
        return this.bufferedLength += length;
    }

    protected final void getBufferedData(byte[] output, int offset) {
        System.arraycopy(this.bufferedData, 0, output, offset, this.bufferedLength);
        this.bufferedLength = 0;
    }

    protected abstract int engineTransformBlock(byte[] var1, int var2, int var3, byte[] var4, int var5) throws ShortBufferException;

    protected final void _engineSetPadding(String paddingName) throws NoSuchPaddingException {
        this.paddingName = paddingName;
        if (paddingName.equalsIgnoreCase("NoPadding")) {
            this.padding = 0;
        } else if (paddingName.equalsIgnoreCase("PKCS5Padding") || paddingName.equalsIgnoreCase("PKCS#5Padding")) {
            this.padding = 1;
        } else if (paddingName.equalsIgnoreCase("TLSPadding")) {
            this.padding = 2;
        } else {
            throw new NoSuchPaddingException("Unsupported padding " + this.padding);
        }
    }

    protected int _engineGetOutputSize(int inputLen) {
        int totalInputSize = inputLen + this.bufferedLength;
        int lastblockSize = totalInputSize % this.blockSize;
        int minPaddingSize = this.blockSize - lastblockSize;
        switch (this.padding) {
            case 2: {
                return 256 + inputLen + this.blockSize;
            }
            case 1: {
                if (lastblockSize == 0) {
                    return totalInputSize + this.blockSize;
                }
                return totalInputSize + minPaddingSize;
            }
            case 0: {
                return totalInputSize;
            }
        }
        return 0;
    }

    protected byte[] _engineUpdate(byte[] input, int inputOffset, int inputLength) {
        int length = 0;
        byte[] out = new byte[this.engineGetOutputSize(inputLength)];
        try {
            length = this._engineUpdate(input, inputOffset, inputLength, out, 0);
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    protected int _engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException {
        int sBufferLength = this.bufferedLength;
        int totalInputSize = inputLength + sBufferLength;
        int blockSize = this.engineGetBlockSize();
        int safeOutputLength = totalInputSize - 256;
        if (safeOutputLength <= 0) {
            if (input != null) {
                this.addToBufferedData(input, inputOffset, inputLength);
            }
            return 0;
        }
        int outputLength = 0;
        int transformedLength = 0;
        if (sBufferLength <= safeOutputLength) {
            int moreInputLength;
            int glitch_bt;
            if (sBufferLength >= blockSize) {
                for (transformedLength = 0; transformedLength < sBufferLength - blockSize; transformedLength += blockSize) {
                    outputLength += this.engineTransformBlock(this.bufferedData, transformedLength, blockSize, output, outputOffset + outputLength);
                }
            }
            if (blockSize - (glitch_bt = sBufferLength - transformedLength) <= (moreInputLength = safeOutputLength - sBufferLength)) {
                System.arraycopy(this.bufferedData, transformedLength, this.tempBlock, 0, glitch_bt);
                System.arraycopy(input, inputOffset, this.tempBlock, glitch_bt, blockSize - glitch_bt);
                outputLength += this.engineTransformBlock(this.tempBlock, 0, blockSize, output, outputOffset + outputLength);
                for (transformedLength = inputOffset + (blockSize - glitch_bt); transformedLength < moreInputLength + inputOffset; transformedLength += blockSize) {
                    outputLength += this.engineTransformBlock(input, transformedLength, blockSize, output, outputOffset + outputLength);
                }
                this.bufferedLength = 0;
                this.addToBufferedData(input, transformedLength, inputLength - (transformedLength - inputOffset));
            } else {
                int destBuffLen = this.bufferedLength;
                this.bufferedLength = 0;
                this.addToBufferedData(this.bufferedData, destBuffLen - glitch_bt, glitch_bt);
                this.addToBufferedData(input, inputOffset, inputLength);
            }
        } else if (safeOutputLength >= blockSize) {
            for (transformedLength = 0; transformedLength < safeOutputLength - blockSize; transformedLength += blockSize) {
                outputLength += this.engineTransformBlock(this.bufferedData, transformedLength, blockSize, output, outputOffset + outputLength);
            }
            int lastBufferLength = this.bufferedLength;
            this.bufferedLength = 0;
            if (transformedLength < lastBufferLength) {
                this.addToBufferedData(this.bufferedData, transformedLength, lastBufferLength - transformedLength);
            }
            this.addToBufferedData(input, inputOffset, inputLength);
        } else {
            this.addToBufferedData(input, inputOffset, inputLength);
        }
        return outputLength;
    }

    protected byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLength) throws IllegalBlockSizeException, BadPaddingException {
        int length = 0;
        byte[] out = new byte[this.engineGetOutputSize(inputLength)];
        length = this._engineDoFinal(input, inputOffset, inputLength, out, 0);
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            Arrays.fill(out, (byte)0);
            out = shorter;
        }
        return out;
    }

    protected int _engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        int outputLength = 0;
        try {
            outputLength += this._engineUpdate(input, inputOffset, inputLength, output, outputOffset);
        }
        catch (ShortBufferException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
        try {
            switch (this.cipherMode) {
                case 2: {
                    int i;
                    for (i = 0; i < this.bufferedLength; i += this.blockSize) {
                        outputLength += this.engineTransformBlock(this.bufferedData, i, this.blockSize, output, outputOffset + outputLength);
                    }
                    this.bufferedLength = 0;
                    if (this.originalIV != null) {
                        this.iv = (byte[])this.originalIV.clone();
                    }
                    if (this.padding != 0) {
                        int paddingLength = output[outputOffset + outputLength - 1] & 0xFF;
                        if (paddingLength < 0 || paddingLength > 255) {
                            throw new BadPaddingException("PKCS5 or TLS: " + paddingLength);
                        }
                        if (outputLength - paddingLength < 0) {
                            throw new BadPaddingException("minus padding: " + (outputLength - paddingLength) + " < 0, padding length = " + paddingLength);
                        }
                        for (i = 2; i <= paddingLength; ++i) {
                            if ((output[outputOffset + outputLength - paddingLength] & 0xFF) == paddingLength) continue;
                            throw new BadPaddingException("Padding does not match");
                        }
                        i = outputLength - paddingLength;
                        return i;
                    }
                    i = outputLength;
                    return i;
                }
                case 1: {
                    int paddingLength = this.getPaddingLength(this.bufferedLength % this.blockSize);
                    int oldBufferLength = this.bufferedLength;
                    this.getBufferedData(this.tempBlock, 0);
                    this.getPadded(paddingLength, this.tempBlock, oldBufferLength);
                    for (int i = 0; i < paddingLength + oldBufferLength; i += this.blockSize) {
                        outputLength += this.engineTransformBlock(this.tempBlock, i, this.blockSize, output, outputOffset + outputLength);
                    }
                    if (this.originalIV != null) {
                        this.iv = (byte[])this.originalIV.clone();
                    }
                    int n = outputLength;
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        catch (ShortBufferException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
        finally {
            Arrays.fill(this.tempBlock, (byte)0);
            Arrays.fill(this.bufferedData, (byte)0);
        }
    }

    protected int getPaddingLength(int lastBytesLeft) {
        int minPaddingSize = this.blockSize - lastBytesLeft;
        switch (this.padding) {
            case 0: {
                if (lastBytesLeft == 0) {
                    return lastBytesLeft;
                }
            }
            case 1: {
                if (minPaddingSize == 0) {
                    return this.blockSize;
                }
                return minPaddingSize;
            }
            case 2: {
                if (this.tlsPaddingLength == 0) {
                    int nPaddingBlocks;
                    if (this.random == null) {
                        this.random = new SecureRandom();
                    }
                    if ((nPaddingBlocks = this.random.nextInt() % (256 / this.blockSize - 1)) < 0) {
                        nPaddingBlocks = -nPaddingBlocks;
                    }
                    this.tlsPaddingLength = nPaddingBlocks * this.blockSize + minPaddingSize;
                    return this.tlsPaddingLength;
                }
                return this.tlsPaddingLength;
            }
        }
        return 0;
    }

    protected void getPadded(int paddingLength, byte[] in, int inOff) {
        switch (this.padding) {
            case 0: {
                if (paddingLength == 0) break;
                break;
            }
            case 1: 
            case 2: {
                for (int i = inOff; i < inOff + paddingLength; ++i) {
                    in[i] = (byte)paddingLength;
                }
                break;
            }
        }
    }
}

