/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.SecretKey;
import com.initech.cryptox.spec.RC2ParameterSpec;
import com.initech.provider.crypto.cipher.BlockCipher;
import com.initech.provider.crypto.cipher.RC2Key;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class RC2
extends BlockCipher {
    private int[] skey = new int[64];
    protected static final int BLOCK_SIZE = 8;
    protected int bits;
    private static final byte[] key_table = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};
    protected byte[] ivec = null;

    public RC2() {
        this.setBlockSize(8);
        this.bits = 1024;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            super.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            // empty catch block
        }
        this.ivec = new byte[this.engineGetBlockSize()];
        random.nextBytes(this.ivec);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params instanceof RC2ParameterSpec) {
            RC2ParameterSpec spec = (RC2ParameterSpec)params;
            this.bits = spec.getEffectiveKeyBits();
            if (spec.getIV() != null) {
                this.ivec = (byte[])spec.getIV().clone();
            }
        } else {
            throw new InvalidAlgorithmParameterException("RC2Parameter only");
        }
        super.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        RC2ParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(RC2ParameterSpec.class);
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException("Couldn't get RC2ParameterSpec: " + e);
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    protected byte[] engineGetIV() {
        return (byte[])this.ivec.clone();
    }

    protected void setKey(Key key) throws InvalidKeyException {
        for (int m = 0; m < this.skey.length; ++m) {
            this.skey[m] = 0;
        }
        if (!(key instanceof RC2Key) && !(key instanceof SecretKey)) {
            throw new InvalidKeyException("key is not RC2Key");
        }
        byte[] k = key.getEncoded();
        int len = k.length;
        if (len > 128) {
            len = 128;
        }
        byte[] sk = new byte[128];
        if (k == null || k.length == 0) {
            sk[0] = 0;
        } else {
            for (int m = 0; m < len; ++m) {
                sk[m] = k[m];
            }
        }
        byte d = sk[len - 1];
        int j = 0;
        int i = len;
        while (i < 128) {
            sk[i] = d = key_table[sk[j] + d & 0xFF];
            ++i;
            ++j;
        }
        if (this.bits > 1024 | this.bits <= 0) {
            this.bits = 1024;
        }
        j = this.bits + 7 >>> 3;
        i = 128 - j;
        int c = 255 >>> (-this.bits & 7);
        sk[i] = d = key_table[sk[i] & c];
        while (i-- != 0) {
            sk[i] = d = key_table[(byte)(sk[i + j] ^ d) & 0xFF];
        }
        d = key_table[sk[128 - len] & 0xFF];
        for (int l = 63; l >= 0; --l) {
            this.skey[l] = (sk[l * 2 + 1] << 8 & 0xFF00 | sk[l * 2] & 0xFF) & 0xFFFF;
        }
    }

    public int encryptBlock(byte[] input, int inOff, int len, byte[] output, int outOff) throws IllegalBlockSizeException {
        int x0 = input[inOff + 1] << 8 & 0xFF00 | input[inOff + 0] << 0 & 0xFF;
        int x1 = input[inOff + 3] << 8 & 0xFF00 | input[inOff + 2] << 0 & 0xFF;
        int x2 = input[inOff + 5] << 8 & 0xFF00 | input[inOff + 4] << 0 & 0xFF;
        int x3 = input[inOff + 7] << 8 & 0xFF00 | input[inOff + 6] << 0 & 0xFF;
        int n = 3;
        int i = 5;
        int p0 = 0;
        boolean p1 = false;
        while (true) {
            int t = x0 + (x1 & ~x3) + (x2 & x3) + this.skey[p0++] & 0xFFFF;
            x0 = t << 1 | t >>> 15;
            t = x1 + (x2 & ~x0) + (x3 & x0) + this.skey[p0++] & 0xFFFF;
            x1 = t << 2 | t >>> 14;
            t = x2 + (x3 & ~x1) + (x0 & x1) + this.skey[p0++] & 0xFFFF;
            x2 = t << 3 | t >>> 13;
            t = x3 + (x0 & ~x2) + (x1 & x2) + this.skey[p0++] & 0xFFFF;
            x3 = t << 5 | t >>> 11;
            if (--i != 0) continue;
            if (--n == 0) break;
            i = n == 2 ? 6 : 5;
            x2 += this.skey[(x1 += this.skey[(x0 += this.skey[x3 & 0x3F]) & 0x3F]) & 0x3F];
            x3 += this.skey[x2 & 0x3F];
        }
        output[0 + outOff] = (byte)(x0 >>> 0 & 0xFF);
        output[1 + outOff] = (byte)(x0 >>> 8 & 0xFF);
        output[2 + outOff] = (byte)(x1 >>> 0 & 0xFF);
        output[3 + outOff] = (byte)(x1 >>> 8 & 0xFF);
        output[4 + outOff] = (byte)(x2 >>> 0 & 0xFF);
        output[5 + outOff] = (byte)(x2 >>> 8 & 0xFF);
        output[6 + outOff] = (byte)(x3 >>> 0 & 0xFF);
        output[7 + outOff] = (byte)(x3 >>> 8 & 0xFF);
        return 8;
    }

    public int decryptBlock(byte[] input, int inOff, int len, byte[] output, int outOff) {
        int x0 = input[inOff + 1] << 8 & 0xFF00 | input[inOff + 0] << 0 & 0xFF;
        int x1 = input[inOff + 3] << 8 & 0xFF00 | input[inOff + 2] << 0 & 0xFF;
        int x2 = input[inOff + 5] << 8 & 0xFF00 | input[inOff + 4] << 0 & 0xFF;
        int x3 = input[inOff + 7] << 8 & 0xFF00 | input[inOff + 6] << 0 & 0xFF;
        int n = 3;
        int i = 5;
        int p0 = 63;
        boolean p1 = false;
        while (true) {
            int t = (x3 << 11 | x3 >>> 5) & 0xFFFF;
            x3 = t - (x0 & ~x2) - (x1 & x2) - this.skey[p0--] & 0xFFFF;
            t = (x2 << 13 | x2 >>> 3) & 0xFFFF;
            x2 = t - (x3 & ~x1) - (x0 & x1) - this.skey[p0--] & 0xFFFF;
            t = (x1 << 14 | x1 >>> 2) & 0xFFFF;
            x1 = t - (x2 & ~x0) - (x3 & x0) - this.skey[p0--] & 0xFFFF;
            t = (x0 << 15 | x0 >>> 1) & 0xFFFF;
            x0 = t - (x1 & ~x3) - (x2 & x3) - this.skey[p0--] & 0xFFFF;
            if (--i != 0) continue;
            if (--n == 0) break;
            i = n == 2 ? 6 : 5;
            x3 = x3 - this.skey[x2 & 0x3F] & 0xFFFF;
            x2 = x2 - this.skey[x1 & 0x3F] & 0xFFFF;
            x1 = x1 - this.skey[x0 & 0x3F] & 0xFFFF;
            x0 = x0 - this.skey[x3 & 0x3F] & 0xFFFF;
        }
        output[0 + outOff] = (byte)(x0 >>> 0 & 0xFF);
        output[1 + outOff] = (byte)(x0 >>> 8 & 0xFF);
        output[2 + outOff] = (byte)(x1 >>> 0 & 0xFF);
        output[3 + outOff] = (byte)(x1 >>> 8 & 0xFF);
        output[4 + outOff] = (byte)(x2 >>> 0 & 0xFF);
        output[5 + outOff] = (byte)(x2 >>> 8 & 0xFF);
        output[6 + outOff] = (byte)(x3 >>> 0 & 0xFF);
        output[7 + outOff] = (byte)(x3 >>> 8 & 0xFF);
        return 8;
    }
}

