/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.KeyGeneratorSpi;
import com.initech.cryptox.spec.RC2ParameterSpec;
import com.initech.provider.crypto.cipher.RC2Key;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class RC2KeyGenerator
extends KeyGeneratorSpi {
    SecureRandom rand;
    private int len = 8;

    protected void _engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof RC2ParameterSpec)) {
            this.len = 8;
            throw new InvalidAlgorithmParameterException("Not Support AlgotithmParameterSpec");
        }
        RC2ParameterSpec p = (RC2ParameterSpec)params;
        this.len = p.getEffectiveKeyBits() / 8 + 1;
    }

    protected void _engineInit(SecureRandom random) {
        this.rand = random;
        this.len = 8;
    }

    protected void _engineInit(int strength, SecureRandom random) {
        this.rand = random;
    }

    protected SecretKey _engineGenerateKey() {
        if (this.rand == null) {
            this.rand = new SecureRandom();
        }
        byte[] bytes = new byte[this.len];
        RC2Key key = null;
        this.rand.nextBytes(bytes);
        key = new RC2Key(bytes);
        return key;
    }
}

