/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.cryptox.AlgorithmParametersSpi;
import com.initech.cryptox.spec.RC2ParameterSpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.spec.KeySizeSpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RC2Parameters
extends AlgorithmParametersSpi
implements ASN1Type {
    private static final long serialVersionUID = -9201606531880533594L;
    protected byte[] initialVector;
    protected int effectiveKeyBits;

    public void RC2Paramteres() {
    }

    public void RC2Paramteres(byte[] asn1OctetString) throws ASN1Exception {
        BERDecoder rc2asn1 = new BERDecoder(asn1OctetString);
        this.decode(rc2asn1);
    }

    protected byte[] _engineGetEncoded() throws IOException {
        try {
            DEREncoder enc = new DEREncoder();
            this.encode(enc);
            return enc.toByteArray();
        }
        catch (ASN1Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected byte[] _engineGetEncoded(String format) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec _engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (RC2ParameterSpec.class.isAssignableFrom(paramSpec)) {
            return new RC2ParameterSpec(this.effectiveKeyBits, this.initialVector);
        }
        if (KeySizeSpec.class.isAssignableFrom(paramSpec)) {
            return new KeySizeSpec(this.effectiveKeyBits / 8);
        }
        throw new InvalidParameterSpecException("Not a RC2ParameterSpec assignable spec");
    }

    protected void _engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!((paramSpec = (AlgorithmParameterSpec)AutoJCE.toJCEX(paramSpec)) instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException("Not a RC2ParameterSpec");
        }
        this.effectiveKeyBits = ((RC2ParameterSpec)paramSpec).getEffectiveKeyBits();
        this.initialVector = ((RC2ParameterSpec)paramSpec).getIV();
    }

    protected void _engineInit(byte[] asn1data) throws IOException {
        try {
            this.decode(new BERDecoder(asn1data));
        }
        catch (ASN1Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected void _engineInit(byte[] asn1data, String format) throws IOException {
        this._engineInit(asn1data);
    }

    protected String _engineToString() {
        return "Initech RC2Parameters (ASN.1 Encoding)";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(ASN1Decoder rc2asn1) throws ASN1Exception {
        int seqid = rc2asn1.decodeSequence();
        if (!rc2asn1.nextIsOptional(2)) {
            int version = rc2asn1.decodeIntegerAsInt();
            if (version == 160) {
                this.effectiveKeyBits = 40;
            } else if (version == 120) {
                this.effectiveKeyBits = 64;
            } else if (version == 58) {
                this.effectiveKeyBits = 128;
            } else {
                if (version < 256) throw new ASN1Exception("RC2 version is not recognized.");
                this.effectiveKeyBits = version;
            }
        } else {
            this.effectiveKeyBits = 128;
        }
        this.initialVector = rc2asn1.decodeOctetString();
        if (this.initialVector.length != 8) {
            throw new ASN1Exception("RC2 Initial vector length: " + new Integer(this.initialVector.length) + " which should be 8");
        }
        rc2asn1.endOf(seqid);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seqid = enc.encodeSequence();
        if (this.effectiveKeyBits != 128) {
            int version;
            if (this.effectiveKeyBits == 40) {
                version = 160;
            } else if (this.effectiveKeyBits == 64) {
                version = 120;
            } else if (this.effectiveKeyBits == 128) {
                version = 58;
            } else if (this.effectiveKeyBits >= 256) {
                version = this.effectiveKeyBits;
            } else {
                throw new ASN1Exception("RC2 version is not recognized.");
            }
            enc.encodeInteger(version);
        }
        enc.encodeOctetString(this.initialVector);
        enc.endOf(seqid);
    }
}

