/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.CipherSpi;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.cryptox.ShortBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class RC4
extends CipherSpi {
    private static final int CODESPACE = 256;
    private int[] S = new int[256];
    private byte[] key;
    private int i;
    private int j;
    private int swapTemp;

    private void initializeS() {
        int[] S2 = new int[256];
        this.i = 0;
        while (this.i < 256) {
            this.S[this.i] = this.i;
            S2[this.i] = this.key[this.i % this.key.length] & 0xFF;
            ++this.i;
        }
        this.i = 0;
        this.j = 0;
        while (this.i < 256) {
            this.j = (this.j + this.S[this.i] + S2[this.i]) % 256;
            this.swapTemp = this.S[this.i];
            this.S[this.i] = this.S[this.j];
            this.S[this.j] = this.swapTemp;
            ++this.i;
        }
        this.swapTemp = 0;
        this.j = 0;
        this.i = 0;
    }

    private byte nextPseudoRandom() {
        this.i = (this.i + 1) % 256;
        this.j = (this.j + this.S[this.i]) % 256;
        this.swapTemp = this.S[this.i];
        this.S[this.i] = this.S[this.j];
        this.S[this.j] = this.swapTemp;
        byte ret = (byte)this.S[(this.S[this.i] + this.S[this.j]) % 256];
        return ret;
    }

    protected void _engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("No mode nedded for RC4");
    }

    protected void _engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("No padding nedded for RC4");
    }

    protected int _engineGetBlockSize() {
        return 1;
    }

    protected int _engineGetOutputSize(int inputLen) {
        return inputLen;
    }

    protected byte[] _engineGetIV() {
        return null;
    }

    protected AlgorithmParameters _engineGetParameters() {
        return null;
    }

    protected void _engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.key = key.getEncoded();
        this.initializeS();
    }

    protected void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    protected void _engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    protected byte[] _engineUpdate(byte[] input, int inputOff, int inputLen) {
        byte[] xored = new byte[inputLen];
        for (int i = 0; i < inputLen; ++i) {
            xored[i] = (byte)(this.nextPseudoRandom() ^ input[i + inputOff]);
        }
        return xored;
    }

    protected int _engineUpdate(byte[] input, int inputOff, int inputLen, byte[] output, int outputOff) throws ShortBufferException {
        int i = inputOff;
        int j = outputOff;
        while (i < inputOff + inputLen) {
            output[j] = (byte)(this.nextPseudoRandom() ^ input[i]);
            ++i;
            ++j;
        }
        return inputLen;
    }

    protected byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(input, inputOffset, inputLen);
    }

    protected int _engineDoFinal(byte[] input, int inputOff, int inputLen, byte[] output, int outputOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this._engineUpdate(input, inputOff, inputLen, output, outputOff);
    }
}

