/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.RC4Key;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class RC4KeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            if (skspec.getAlgorithm().indexOf("RC4") == -1) {
                throw new InvalidKeySpecException("SecretKeySpec not for RC4");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            return new RC4Key(skspec.getEncoded());
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for RC4.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof RC4Key && SecretKeySpec.class.isAssignableFrom(keySpec)) {
            return new SecretKeySpec(key.getEncoded(), "RC4");
        }
        throw new InvalidKeySpecException("Only RC4Key => SecretKeySpec");
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("RC4")) {
            throw new InvalidKeyException("not a RC4 key");
        }
        return new RC4Key(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKey(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("RC4")) {
            throw new InvalidKeyException("not a RC4 key");
        }
        return new RC4Key(key.getEncoded());
    }
}

