/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.spec.RC5ParameterSpec;
import com.initech.provider.crypto.cipher.BlockCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class RC5
extends BlockCipher {
    protected short wordSize = (short)32;
    protected short wordBytes = (short)4;
    protected short round;
    protected int version;
    protected long[] S;
    protected byte[] ivec = null;
    final long P16 = 47073L;
    final long Q16 = 40503L;
    final long P32 = 3084996963L;
    final long Q32 = 2654435769L;
    final long P64 = -5196783011329398165L;
    final long Q64 = -7046029254386353131L;
    protected long P;
    protected long Q;
    final long F16 = 65535L;
    final long F32 = 0xFFFFFFFFL;
    final long F64 = -1L;
    protected long fMask;

    public RC5() {
        this.setBlockSize(8);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            super.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            // empty catch block
        }
        this.ivec = new byte[this.engineGetBlockSize()];
        random.nextBytes(this.ivec);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params instanceof RC5ParameterSpec) {
            RC5ParameterSpec spec = (RC5ParameterSpec)params;
            this.round = (short)spec.getRounds();
            this.version = spec.getVersion();
            if (this.version != 16) {
                throw new InvalidAlgorithmParameterException("RC5 version 0x10 only, not " + this.version);
            }
            this.wordSize = (short)spec.getWordSize();
            this.wordBytes = (short)(this.wordSize / 8);
            this.setBlockSize(this.wordBytes * 2);
            if (this.wordSize <= 16) {
                this.P = 47073L;
                this.Q = 40503L;
                this.fMask = 65535L;
            } else if (this.wordSize <= 32) {
                this.P = 3084996963L;
                this.Q = 2654435769L;
                this.fMask = 0xFFFFFFFFL;
            } else {
                this.P = -5196783011329398165L;
                this.Q = -7046029254386353131L;
                this.fMask = -1L;
            }
            if (spec.getIV() != null) {
                this.ivec = (byte[])spec.getIV().clone();
            }
        } else {
            throw new InvalidAlgorithmParameterException("RC5ParameterSpec only");
        }
        super.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        RC5ParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(RC5ParameterSpec.class);
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException("Couldn't get RC5ParameterSpec: " + e);
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    protected byte[] engineGetIV() {
        return (byte[])this.ivec.clone();
    }

    protected void setKey(Key key) throws InvalidKeyException {
        byte[] rawKey = key.getEncoded();
        int kLength = rawKey.length;
        int c = kLength != 0 ? (int)((short)((kLength + this.wordBytes - 1) / this.wordBytes)) : 1;
        long[] L = new long[c];
        L[0] = 0L;
        for (int i = 0; i < kLength; i += this.wordBytes) {
            L[i / this.wordBytes] = this.bytes2long(rawKey, i);
        }
        int t = 2 * (this.round + 1);
        this.S = new long[t];
        this.S[0] = this.P;
        int i = 1;
        while (i < t) {
            this.S[i] = this.S[i - 1] + this.Q;
            int n = i++;
            this.S[n] = this.S[n] & this.fMask;
        }
        i = 0;
        int j = 0;
        long A = 0L;
        long B = 0L;
        int max = t >= c ? t : c;
        for (int k = 0; k < 3 * max; ++k) {
            long temp = this.S[i] + A + B;
            A = (temp &= this.fMask) << 3 | temp >>> this.wordSize - (3 & this.wordSize - 1);
            this.S[i] = A &= this.fMask;
            temp = L[j] + A + B;
            B = (temp &= this.fMask) << (int)(A + B & (long)(this.wordSize - 1)) | temp >>> (int)((long)this.wordSize - (A + B & (long)(this.wordSize - 1)));
            L[j] = B &= this.fMask;
            i = (short)((i + 1) % t);
            j = (short)((j + 1) % c);
        }
    }

    protected int encryptBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalBlockSizeException {
        long A = this.bytes2long(input, inputOffset);
        long B = this.bytes2long(input, inputOffset + this.wordBytes);
        A += this.S[0];
        B += this.S[1];
        A &= this.fMask;
        B &= this.fMask;
        for (int i = 1; i <= this.round; ++i) {
            A ^= B;
            A = A << (int)(B & (long)(this.wordSize - 1)) | A >>> (int)((long)this.wordSize - (B & (long)(this.wordSize - 1)));
            A &= this.fMask;
            A += this.S[2 * i];
            B ^= (A &= this.fMask);
            B = B << (int)(A & (long)(this.wordSize - 1)) | B >>> (int)((long)this.wordSize - (A & (long)(this.wordSize - 1)));
            B &= this.fMask;
            B += this.S[2 * i + 1];
            B &= this.fMask;
        }
        this.long2bytes(A, output, outputOffset);
        this.long2bytes(B, output, outputOffset + this.wordBytes);
        return 2 * this.wordBytes;
    }

    protected int decryptBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        long A = this.bytes2long(input, inputOffset);
        long B = this.bytes2long(input, inputOffset + this.wordBytes);
        for (int i = this.round; i >= 1; --i) {
            B -= this.S[2 * i + 1];
            B &= this.fMask;
            B = B >>> (int)(A & (long)(this.wordSize - 1)) | B << (int)((long)this.wordSize - (A & (long)(this.wordSize - 1)));
            B ^= A;
            A &= this.fMask;
            A -= this.S[2 * i];
            A &= this.fMask;
            A = A >>> (int)(B & (long)(this.wordSize - 1)) | A << (int)((long)this.wordSize - (B & (long)(this.wordSize - 1)));
            A ^= B;
            A &= this.fMask;
            B &= this.fMask;
        }
        B -= this.S[1];
        A -= this.S[0];
        this.long2bytes(A &= this.fMask, output, outputOffset);
        this.long2bytes(B &= this.fMask, output, outputOffset + this.wordBytes);
        return 2 * this.wordBytes;
    }

    void long2bytes(long in, byte[] out, int offset) {
        for (int j = 0; j < this.wordBytes; ++j) {
            out[j + offset] = (byte)(in >>> 8 * j & 0xFFL);
        }
    }

    long bytes2long(byte[] x, int offset) {
        long ret = 0L;
        for (int j = 0; j < this.wordBytes; ++j) {
            ret += (long)(x[j + offset] & 0xFF) << 8 * j;
        }
        return ret;
    }
}

