/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.RC5Key;
import com.initech.provider.crypto.spec.RC5KeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class RC5KeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RC5KeySpec) {
            return new RC5Key(((RC5KeySpec)keySpec).getKey());
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            if (skspec.getAlgorithm().indexOf("RC5") == -1) {
                throw new InvalidKeySpecException("SecretKeySpec not for RC5");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            return new RC5Key(skspec.getEncoded());
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for RC5.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof RC5Key) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "RC5");
            }
            if (RC5KeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new RC5KeySpec(key.getEncoded());
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
        }
        throw new InvalidKeySpecException("not implemented");
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("RC5")) {
            throw new InvalidKeyException("not a RC5 key");
        }
        return new RC5Key(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKey(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("RC5")) {
            throw new InvalidKeyException("not a RC5 key");
        }
        return new RC5Key(key.getEncoded());
    }
}

