/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.cryptox.AlgorithmParametersSpi;
import com.initech.cryptox.spec.RC5ParameterSpec;
import com.initech.provider.AutoJCE;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RC5Parameters
extends AlgorithmParametersSpi
implements ASN1Type {
    private static final long serialVersionUID = -3673053197566491027L;
    protected byte[] initialVector = null;
    protected int version;
    protected int rounds;
    protected int wordSize;

    public void RC5Paramteres() {
    }

    public void RC5Paramteres(byte[] asn1OctetString) throws ASN1Exception {
        BERDecoder rc5asn1 = new BERDecoder(asn1OctetString);
        this.decode(rc5asn1);
    }

    protected byte[] _engineGetEncoded() throws IOException {
        try {
            DEREncoder enc = new DEREncoder();
            this.encode(enc);
            return enc.toByteArray();
        }
        catch (ASN1Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected byte[] _engineGetEncoded(String format) throws IOException {
        return this._engineGetEncoded();
    }

    protected AlgorithmParameterSpec _engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (RC5ParameterSpec.class.isAssignableFrom(paramSpec)) {
            if (this.initialVector != null) {
                return new RC5ParameterSpec(this.version, this.rounds, this.wordSize, this.initialVector);
            }
            return new RC5ParameterSpec(this.version, this.rounds, this.wordSize);
        }
        throw new InvalidParameterSpecException("Not a RC5ParameterSpec assignable spec");
    }

    protected void _engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!((paramSpec = (AlgorithmParameterSpec)AutoJCE.toJCEX(paramSpec)) instanceof RC5ParameterSpec)) {
            throw new InvalidParameterSpecException("Not a RC5ParameterSpec");
        }
        this.version = ((RC5ParameterSpec)paramSpec).getVersion();
        this.rounds = ((RC5ParameterSpec)paramSpec).getRounds();
        this.wordSize = ((RC5ParameterSpec)paramSpec).getWordSize();
        this.initialVector = ((RC5ParameterSpec)paramSpec).getIV();
    }

    protected void _engineInit(byte[] asn1data) throws IOException {
        try {
            this.decode(new BERDecoder(asn1data));
        }
        catch (ASN1Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected void _engineInit(byte[] asn1data, String format) throws IOException {
        this._engineInit(asn1data);
    }

    protected String _engineToString() {
        return "Initech RC5Parameters (ASN.1 Encoding) see RFC 2040";
    }

    public void decode(ASN1Decoder rc5asn1) throws ASN1Exception {
        int seqid = rc5asn1.decodeSequence();
        this.version = rc5asn1.decodeIntegerAsInt();
        if (this.version != 16) {
            throw new ASN1Exception("RC5 version is not recognized.");
        }
        this.rounds = rc5asn1.decodeIntegerAsInt();
        if (this.rounds < 8 || this.rounds > 127) {
            throw new ASN1Exception("RC5 number of rounds out of bound: " + this.rounds);
        }
        int blockSizeInBits = rc5asn1.decodeIntegerAsInt();
        if (blockSizeInBits < 64 || blockSizeInBits > 128) {
            throw new ASN1Exception("RC5 block size in bits out of bound: " + blockSizeInBits);
        }
        this.wordSize = blockSizeInBits / 2;
        this.initialVector = (byte[])(!rc5asn1.nextIsOptional(2) ? rc5asn1.decodeOctetString() : null);
        rc5asn1.endOf(seqid);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seqid = enc.encodeSequence();
        if (this.version != 16) {
            throw new ASN1Exception("RC5 version is not recognized(0x10).");
        }
        enc.encodeInteger(this.version);
        if (this.rounds < 8 || this.rounds > 127) {
            throw new ASN1Exception("RC5 number of rounds out of bound(8-127): " + this.rounds);
        }
        enc.encodeInteger(this.rounds);
        if (this.wordSize * 2 < 64 || this.wordSize * 2 > 128) {
            throw new ASN1Exception("RC5 block size in bits out of bound(64,128): " + this.wordSize * 2);
        }
        enc.encodeInteger(this.wordSize * 2);
        if (this.initialVector != null) {
            enc.encodeOctetString(this.initialVector);
        }
        enc.endOf(seqid);
    }
}

