/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.CipherSpi;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.cryptox.ShortBufferException;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.random.HashDRBG;
import com.initech.provider.crypto.spec.RSAOAEPParameterSpec;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class RSA
extends CipherSpi {
    public static final int PKCS1Padding = 0;
    public static final int OAEPPadding = 1;
    public static final int NoPadding = 2;
    public static final int AutoPadding = 3;
    public static final int OAEP20Padding = 4;
    public static final int OAEP21Padding = 5;
    public int hLen;
    public static final int PKCS1PAD_LEN = 11;
    private String hashAlg = "SHA256";
    int keySize = 0;
    int padding = 0;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    protected byte[] bufferedData;
    protected int bufferedLength;
    protected int cipherMode;
    protected SecureRandom random;
    public Key key;
    protected RSAOAEPParameterSpec oaepparam;
    private boolean debug = false;

    public RSA() {
        try {
            this._engineSetPadding("PKCS1Padding");
            this._engineSetMode("ECB");
        }
        catch (NoSuchPaddingException e) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    protected void checkBufferedData() {
        if (this.bufferedData == null || this.bufferedData.length != this._engineGetBlockSize()) {
            this.bufferedData = new byte[this._engineGetBlockSize()];
            this.bufferedLength = 0;
        }
    }

    protected int getBufferedDataLength() {
        this.checkBufferedData();
        return this.bufferedLength;
    }

    protected void getBufferedData(byte[] output, int offset) {
        this.checkBufferedData();
        System.arraycopy(this.bufferedData, 0, output, offset, this.bufferedLength);
        this.bufferedLength = 0;
    }

    protected int addToBufferedData(byte[] input, int offset, int length) {
        this.checkBufferedData();
        System.arraycopy(input, offset, this.bufferedData, this.bufferedLength, length);
        return this.bufferedLength += length;
    }

    public void _engineSetMode(String modeName) throws NoSuchAlgorithmException {
        if (!modeName.equals("ECB") && !modeName.equals("")) {
            throw new NoSuchAlgorithmException("RSA only uses ECB mode. Cannot use: " + modeName);
        }
    }

    protected void setKey(Key key) {
        int temp = 0;
        if (key instanceof RSAPublicKey) {
            if (this.padding == 1 && this.cipherMode == 2) {
                throw new IllegalArgumentException("can't Decrypt by public key on OAEPPadding");
            }
            temp = ((RSAPublicKey)key).getModulus().bitLength();
        } else if (key instanceof RSAPrivateKey) {
            if (this.padding == 1 && this.cipherMode == 1) {
                throw new IllegalArgumentException("can't Encrypt by private key on OAEPPadding");
            }
            temp = ((RSAPrivateKey)key).getModulus().bitLength();
        } else if (key instanceof RSAPrivateCrtKey) {
            if (this.padding == 1 && this.cipherMode == 1) {
                throw new IllegalArgumentException("can't Encrypt by private key on OAEPPadding");
            }
            temp = ((RSAPrivateCrtKey)key).getModulus().bitLength();
        }
        this.keySize = (temp + 7) / 8;
        this.key = key;
    }

    public void _engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding.equals("PKCS1Padding")) {
            this.padding = 0;
        } else if (padding.equals("OAEPPadding")) {
            this.padding = 1;
        } else if (padding.equals("NoPadding")) {
            this.padding = 2;
        } else if (padding.equals("AutoPadding")) {
            this.padding = 3;
        } else if (padding.equals("OAEP21Padding")) {
            this.padding = 1;
        } else if (padding.equals("OAEP20Padding")) {
            this.padding = 4;
        } else {
            throw new NoSuchPaddingException("Unsupported padding " + padding);
        }
    }

    public int _engineGetKeySize(Key key) throws InvalidKeyException {
        int temp = 0;
        if (key instanceof RSAPublicKey) {
            temp = ((RSAPublicKey)key).getModulus().bitLength();
        } else if (key instanceof RSAPrivateKey) {
            temp = ((RSAPrivateKey)key).getModulus().bitLength();
        } else {
            throw new InvalidKeyException();
        }
        return (temp + 7) / 8;
    }

    public int _engineGetBlockSize() {
        if (this.padding == 0) {
            if (this.cipherMode == 2) {
                return this.keySize;
            }
            return this.keySize - 11;
        }
        if (this.padding == 1) {
            if (this.cipherMode == 2) {
                return this.keySize;
            }
            return this.keySize - 2 - 2 * this.hLen;
        }
        if (this.padding == 2) {
            return 0;
        }
        return this.keySize;
    }

    public int _engineGetOutputSize(int inputLen) {
        int blockSize = this._engineGetBlockSize();
        int hSize = 0;
        inputLen += this.getBufferedDataLength();
        if (this.padding == 0) {
            hSize = 11;
        } else if (this.padding == 1) {
            hSize = 2 + 2 * this.hLen;
        }
        if (this.cipherMode == 2) {
            return inputLen / blockSize * (blockSize - hSize);
        }
        return (inputLen + blockSize - 1) / blockSize * this.keySize;
    }

    public byte[] _engineGetIV() {
        return null;
    }

    public AlgorithmParameters _engineGetParameters() {
        return null;
    }

    public void _engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this._engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("InvalidAlgorithmParameterException: " + e.getMessage());
        }
    }

    public void _engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec = null;
        this._engineInit(opmode, key, spec, random);
    }

    public void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherMode = opmode;
        this.random = random;
        this.key = key;
        if (params != null && params instanceof RSAOAEPParameterSpec) {
            this.oaepparam = (RSAOAEPParameterSpec)params;
            if (this.debug) {
                System.out.println("paramAlg: " + this.oaepparam.getAlgorithm());
                System.out.println("paramSeed: " + Hex.dumpHex(this.oaepparam.getSeed()));
            }
        }
        this.setKey(key);
    }

    protected final int encryptBlock(byte[] in, int inoff, int len, byte[] out, int outoff) throws IllegalBlockSizeException {
        BigInteger exponent;
        BigInteger modulus;
        byte[] buffer = null;
        if (this.key instanceof RSAPublicKey) {
            if (this.padding == 0) {
                buffer = this.EME_PKCS1v1_5Encode(in, inoff, len, this.keySize - 1);
            } else if (this.padding == 1 || this.padding == 5) {
                buffer = this.EME_OAEPEncode(in, inoff, len, null, this.keySize - 1);
            } else if (this.padding == 4) {
                buffer = this.EME_OAEPEncode20(in, inoff, len, null, this.keySize - 2);
            } else if (this.padding == 2) {
                buffer = new byte[len];
                System.arraycopy(in, inoff, buffer, 0, len);
            }
            modulus = ((RSAPublicKey)this.key).getModulus();
            exponent = ((RSAPublicKey)this.key).getPublicExponent();
        } else {
            if (this.padding == 0) {
                buffer = this.EMSA_PKCS1v1_0Encode(in, inoff, len, this.keySize - 1);
            } else if (this.padding == 2) {
                buffer = new byte[len];
                System.arraycopy(in, inoff, buffer, 0, len);
            }
            modulus = ((RSAPrivateKey)this.key).getModulus();
            exponent = ((RSAPrivateKey)this.key).getPrivateExponent();
        }
        BigInteger plainText = new BigInteger(1, buffer);
        BigInteger cipherText = this.key instanceof RSAPrivateCrtKey ? this.crtProcess(plainText) : plainText.modPow(exponent, modulus);
        byte[] cipByte = cipherText.toByteArray();
        if (cipByte.length > this.keySize) {
            System.arraycopy(cipByte, cipByte.length - this.keySize, out, outoff, this.keySize);
            return this.keySize;
        }
        for (int i = outoff; i < outoff + this.keySize - cipByte.length; ++i) {
            out[i] = 0;
        }
        System.arraycopy(cipByte, 0, out, outoff + this.keySize - cipByte.length, cipByte.length);
        return this.keySize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final int decryptBlock(byte[] in, int inoff, int len, byte[] out, int outoff) throws IllegalBlockSizeException, BadPaddingException {
        BigInteger exponent;
        BigInteger modulus;
        if (len != this.keySize) {
            throw new IllegalBlockSizeException("Check input length before performing RSA!!!!");
        }
        if (this.key instanceof RSAPublicKey) {
            modulus = ((RSAPublicKey)this.key).getModulus();
            exponent = ((RSAPublicKey)this.key).getPublicExponent();
        } else {
            modulus = ((RSAPrivateKey)this.key).getModulus();
            exponent = ((RSAPrivateKey)this.key).getPrivateExponent();
        }
        byte[] buffer = new byte[len];
        System.arraycopy(in, inoff, buffer, 0, len);
        BigInteger cipherText = new BigInteger(1, buffer);
        BigInteger plainText = this.key instanceof RSAPrivateCrtKey ? this.crtProcess(cipherText) : cipherText.modPow(exponent, modulus);
        byte[] plainByte = plainText.toByteArray();
        if (this.key instanceof RSAPublicKey) {
            if (this.padding == 0) {
                buffer = this.EMSA_PKCS1v1_0Decode(plainByte, 0, plainByte.length);
                System.arraycopy(buffer, 0, out, outoff, buffer.length);
                return buffer.length;
            } else {
                if (this.padding != 2) throw new IllegalArgumentException("inappropriate key:" + this.key.toString());
                System.arraycopy(plainByte, 0, out, outoff, plainByte.length);
            }
            return buffer.length;
        } else {
            if (!(this.key instanceof RSAPrivateKey)) return buffer.length;
            if (this.padding == 0) {
                buffer = this.EME_PKCS1v1_5Decode(plainByte, 0, plainByte.length);
                System.arraycopy(buffer, 0, out, outoff, buffer.length);
                return buffer.length;
            } else if (this.padding == 1 || this.padding == 5) {
                byte[] pbyte = new byte[this.keySize - 1];
                if (this.keySize - 1 - plainByte.length > 0) {
                    System.arraycopy(plainByte, 0, pbyte, pbyte.length - plainByte.length, plainByte.length);
                } else {
                    System.arraycopy(plainByte, plainByte.length - pbyte.length, pbyte, 0, pbyte.length);
                }
                buffer = this.EME_OAEPDecode(pbyte, 0, pbyte.length, null);
                System.arraycopy(buffer, 0, out, outoff, buffer.length);
                return buffer.length;
            } else if (this.padding == 4) {
                byte[] pbyte = new byte[this.keySize - 1];
                if (this.keySize - 1 - plainByte.length > 0) {
                    System.arraycopy(plainByte, 0, pbyte, pbyte.length - plainByte.length, plainByte.length);
                } else {
                    System.arraycopy(plainByte, plainByte.length - pbyte.length, pbyte, 0, pbyte.length);
                }
                buffer = this.EME_OAEPDecode20(pbyte, 0, pbyte.length, null);
                System.arraycopy(buffer, 0, out, outoff, buffer.length);
                return buffer.length;
            } else {
                if (this.padding == 2) {
                    System.arraycopy(plainByte, 0, out, outoff, plainByte.length);
                    return plainByte.length;
                }
                if (this.padding != 3) throw new IllegalArgumentException("inappropriate key:" + this.key.toString());
                String version = this.getVersion(plainByte);
                if (version.equals("1.5")) {
                    buffer = this.EME_PKCS1v1_5Decode(plainByte, 0, plainByte.length);
                    System.arraycopy(buffer, 0, out, outoff, buffer.length);
                    return buffer.length;
                } else {
                    if (!version.equals("2.1")) return buffer.length;
                    byte[] pbyte = new byte[this.keySize - 1];
                    if (this.keySize - 1 - plainByte.length > 0) {
                        System.arraycopy(plainByte, 0, pbyte, pbyte.length - plainByte.length, plainByte.length);
                    } else {
                        System.arraycopy(plainByte, plainByte.length - pbyte.length, pbyte, 0, pbyte.length);
                    }
                    buffer = this.EME_OAEPDecode(pbyte, 0, pbyte.length, null);
                    System.arraycopy(buffer, 0, out, outoff, buffer.length);
                }
            }
        }
        return buffer.length;
    }

    private final byte[] EME_PKCS1v1_5Encode(byte[] M, int moff, int mlen, int emLen) throws IllegalBlockSizeException {
        if (mlen > emLen - 10) {
            throw new IllegalBlockSizeException("EME_PKCS1v1_5Encode: message too long");
        }
        byte[] ret = new byte[emLen + 1];
        try {
            HashDRBG random = new HashDRBG("SHA224");
            random.nextBytes(ret);
        }
        catch (Exception e) {
            throw new RuntimeException("can not used SystemRandom");
        }
        int i = 2;
        while (i < emLen - mlen) {
            int n = i++;
            ret[n] = (byte)(ret[n] | 1);
        }
        ret[0] = 0;
        ret[1] = 2;
        ret[emLen - mlen] = 0;
        System.arraycopy(M, moff, ret, ret.length - mlen, mlen);
        return ret;
    }

    private final byte[] EME_PKCS1v1_5Decode(byte[] EM, int moff, int mlen) throws BadPaddingException {
        int i;
        int emLen = mlen - 1;
        if (emLen < 10) {
            throw new BadPaddingException(" EME_PKCS1v1_5Decode: decoding error: length");
        }
        if (EM[0] != 2) {
            throw new BadPaddingException(" EME_PKCS1v1_5Decode: decoding error: 0x02");
        }
        for (i = moff; i < mlen && EM[i] != 0; ++i) {
        }
        if (mlen == i) {
            throw new BadPaddingException(" EME_PKCS1v1_5Decode: decoding error: 0x00 ");
        }
        byte[] ret = new byte[mlen - ++i];
        System.arraycopy(EM, moff + i, ret, 0, ret.length);
        return ret;
    }

    private final byte[] EMSA_PKCS1v1_0Encode(byte[] M, int moff, int mlen, int emLen) {
        if (mlen > emLen - 10) {
            throw new RuntimeException(" EME_PKCS1v1_5Encode: message too long");
        }
        byte[] ret = new byte[emLen + 1];
        for (int i = 2; i < emLen - mlen; ++i) {
            ret[i] = -1;
        }
        ret[0] = 0;
        ret[1] = 1;
        ret[emLen - mlen] = 0;
        System.arraycopy(M, moff, ret, ret.length - mlen, mlen);
        return ret;
    }

    private final byte[] EMSA_PKCS1v1_0Decode(byte[] EM, int moff, int mlen) throws BadPaddingException {
        int i;
        int emLen = mlen - 1;
        if (emLen < 10) {
            throw new BadPaddingException(" EME_PKCS1v1_5Decode: decoding error(1)");
        }
        if (EM[0] != 1) {
            throw new BadPaddingException(" EME_PKCS1v1_5Decode: decoding error(2)");
        }
        for (i = moff; i < mlen && EM[i] != 0; ++i) {
        }
        if (mlen == i) {
            throw new BadPaddingException(" EME_PKCS1v1_5Decode: decoding error: 0x00 ");
        }
        byte[] ret = new byte[mlen - ++i];
        System.arraycopy(EM, moff + i, ret, 0, ret.length);
        return ret;
    }

    private final byte[] EME_OAEPEncode20(byte[] M, int moff, int mlen, byte[] P, int emLen) {
        MessageDigest md = new SHA256();
        if (this.oaepparam != null) {
            try {
                String hashAlg;
                this.hashAlg = hashAlg = this.oaepparam.getAlgorithm();
                md = MessageDigest.getInstance(hashAlg, InitechProvider.NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("\uf9de????? ??? ???\u7531\u044a?????? " + this.oaepparam.getAlgorithm(), e);
            }
        }
        this.hLen = md.getDigestLength();
        if (mlen > emLen - 2 * this.hLen) {
            throw new RuntimeException(" OAEPEncode:message too long");
        }
        if (emLen < 2 * this.hLen + 1) {
            throw new RuntimeException(" OAEPEncode:key size too small");
        }
        byte[] PS = new byte[emLen - mlen - 2 * this.hLen];
        for (int i = 0; i < PS.length; ++i) {
            PS[i] = 0;
        }
        byte[] ret = new byte[emLen + 1];
        try {
            if (P == null) {
                md.update("".getBytes());
            } else {
                md.update(P);
            }
            byte[] n = md.digest();
            System.arraycopy(n, 0, ret, this.hLen, this.hLen);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        byte[] seed = new byte[this.hLen];
        if (this.oaepparam != null) {
            if (this.oaepparam.getSeed() == null) {
                if (this.random == null) {
                    this.random = new SecureRandom();
                }
                this.random.nextBytes(seed);
            } else {
                seed = this.oaepparam.getSeed();
            }
        } else {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(seed);
        }
        System.arraycopy(seed, 0, ret, 0, seed.length);
        System.arraycopy(PS, 0, ret, 2 * this.hLen, PS.length);
        ret[2 * this.hLen + PS.length] = 1;
        System.arraycopy(M, moff, ret, 2 * this.hLen + PS.length + 1, mlen);
        if (this.debug) {
            System.out.println("ret : " + Hex.dumpHex(ret));
            System.out.println("dbMaskLength: " + (emLen - this.hLen));
        }
        byte[] dbMask = this.MGF1(seed, 0, seed.length, emLen - this.hLen + 1);
        if (this.debug) {
            System.out.println("dbMask: " + Hex.dumpHex(dbMask));
        }
        this.byteXor(ret, this.hLen, dbMask, 0, ret, this.hLen, dbMask.length);
        if (this.debug) {
            System.out.println("maskDB: " + Hex.dumpHex(ret));
        }
        byte[] seedMask = this.MGF1(ret, this.hLen, emLen - this.hLen + 1, this.hLen);
        if (this.debug) {
            System.out.println("seedMask: " + Hex.dumpHex(seedMask));
        }
        this.byteXor(ret, 0, seedMask, 0, ret, 0, seedMask.length);
        if (this.debug) {
            System.out.println("encode-EM: " + Hex.dumpHex(ret));
        }
        return ret;
    }

    private final byte[] EME_OAEPEncode(byte[] M, int moff, int mlen, byte[] P, int emLen) {
        MessageDigest md = new SHA256();
        if (this.oaepparam != null) {
            try {
                String hashAlg = this.oaepparam.getAlgorithm();
                if (this.debug) {
                    System.out.println("hashAlg: " + hashAlg);
                }
                this.hashAlg = hashAlg;
                md = MessageDigest.getInstance(hashAlg, InitechProvider.NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("\uf9de????? ??? ???\u7531\u044a?????? " + this.oaepparam.getAlgorithm(), e);
            }
        }
        this.hLen = md.getDigestLength();
        if (mlen > emLen - 2 * this.hLen - 1) {
            throw new RuntimeException(" OAEPEncode:message too long");
        }
        if (emLen < 2 * this.hLen + 1) {
            throw new RuntimeException(" OAEPEncode:key size too small");
        }
        byte[] PS = new byte[emLen - mlen - 2 * this.hLen - 1];
        for (int i = 0; i < PS.length; ++i) {
            PS[i] = 0;
        }
        byte[] ret = new byte[emLen + 1];
        try {
            if (P == null) {
                md.update("".getBytes());
            } else {
                md.update(P);
            }
            byte[] n = md.digest();
            System.arraycopy(n, 0, ret, this.hLen + 1, this.hLen);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        byte[] seed = new byte[this.hLen];
        if (this.oaepparam != null) {
            if (this.oaepparam.getSeed() == null) {
                if (this.random == null) {
                    this.random = new SecureRandom();
                }
                this.random.nextBytes(seed);
            } else {
                seed = this.oaepparam.getSeed();
            }
        } else {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(seed);
        }
        ret[0] = 0;
        System.arraycopy(seed, 0, ret, 1, seed.length);
        System.arraycopy(PS, 0, ret, 2 * this.hLen + 1, PS.length);
        ret[2 * this.hLen + 1 + PS.length] = 1;
        System.arraycopy(M, moff, ret, 2 * this.hLen + 2 + PS.length, mlen);
        if (this.debug) {
            System.out.println("ret: " + Hex.dumpHex(ret));
        }
        byte[] dbMask = this.MGF1(seed, 0, seed.length, emLen - this.hLen);
        this.byteXor(ret, this.hLen + 1, dbMask, 0, ret, this.hLen + 1, dbMask.length);
        byte[] seedMask = this.MGF1(ret, this.hLen + 1, emLen - this.hLen, this.hLen);
        this.byteXor(ret, 1, seedMask, 0, ret, 1, seedMask.length);
        if (this.debug) {
            System.out.println("encode-EM: " + Hex.dumpHex(ret));
        }
        return ret;
    }

    private byte[] EME_OAEPDecode20(byte[] EM, int moff, int mlen, byte[] P) throws BadPaddingException {
        int i;
        int emLen = mlen;
        MessageDigest md = new SHA256();
        if (this.oaepparam != null) {
            try {
                String hashAlg;
                this.hashAlg = hashAlg = this.oaepparam.getAlgorithm();
                md = MessageDigest.getInstance(hashAlg, InitechProvider.NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("\uf9de????? ??? ???\u7531\u044a?????? " + this.oaepparam.getAlgorithm(), e);
            }
        }
        this.hLen = md.getDigestLength();
        if (emLen < 2 * this.hLen) {
            throw new BadPaddingException(" OAEPDecode:decoding error:length");
        }
        byte[] seedMask = this.MGF1(EM, moff + this.hLen, emLen - this.hLen, this.hLen);
        byte[] seed = new byte[seedMask.length];
        this.byteXor(EM, moff, seedMask, 0, seed, 0, seed.length);
        byte[] dbMask = this.MGF1(seed, 0, seed.length, emLen - this.hLen);
        byte[] DB = new byte[emLen - this.hLen];
        this.byteXor(EM, moff + this.hLen, dbMask, 0, DB, 0, DB.length);
        byte[] pHash = null;
        md.reset();
        try {
            if (P == null) {
                md.update("".getBytes());
            } else {
                md.update(P);
            }
            pHash = md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException("failed EME_OAEPDecode cause of SHA1", e);
        }
        if (!this.byteEqual(pHash, 0, DB, 0, pHash.length)) {
            throw new BadPaddingException(" OAEPDecode:decoding error:hash value");
        }
        for (i = this.hLen; i < DB.length && DB[i] != 1; ++i) {
        }
        byte[] ret = new byte[DB.length - i - 1];
        System.arraycopy(DB, i + 1, ret, 0, ret.length);
        return ret;
    }

    private byte[] EME_OAEPDecode(byte[] EM, int moff, int mlen, byte[] P) throws BadPaddingException {
        int i;
        int emLen = mlen;
        MessageDigest md = new SHA256();
        if (this.oaepparam != null) {
            try {
                String hashAlg;
                this.hashAlg = hashAlg = this.oaepparam.getAlgorithm();
                md = MessageDigest.getInstance(hashAlg, InitechProvider.NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("\uf9de????? ??? ???\u7531\u044a?????? " + this.oaepparam.getAlgorithm(), e);
            }
        }
        this.hLen = md.getDigestLength();
        if (emLen < 2 * this.hLen + 1) {
            throw new BadPaddingException(" OAEPDecode:decoding error:length");
        }
        byte[] seedMask = this.MGF1(EM, moff + this.hLen, emLen - this.hLen, this.hLen);
        byte[] seed = new byte[seedMask.length];
        this.byteXor(EM, moff, seedMask, 0, seed, 0, seed.length);
        byte[] dbMask = this.MGF1(seed, 0, seed.length, emLen - this.hLen);
        byte[] DB = new byte[emLen - this.hLen];
        this.byteXor(EM, moff + this.hLen, dbMask, 0, DB, 0, DB.length);
        byte[] pHash = null;
        md.reset();
        try {
            if (P == null) {
                md.update("".getBytes());
            } else {
                md.update(P);
            }
            pHash = md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException("failed EME_OAEPDecode cause of hash", e);
        }
        if (!this.byteEqual(pHash, 0, DB, 0, pHash.length)) {
            throw new BadPaddingException(" OAEPDecode:decoding error:hash value");
        }
        for (i = this.hLen; i < DB.length && DB[i] != 1; ++i) {
        }
        byte[] ret = new byte[DB.length - i - 1];
        System.arraycopy(DB, i + 1, ret, 0, ret.length);
        if (this.debug) {
            System.out.println("decode-DB: " + Hex.dumpHex(DB, ' '));
        }
        return ret;
    }

    private final boolean byteEqual(byte[] a, int aoff, byte[] b, int boff, int len) {
        for (int i = 0; i < len; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private final void byteXor(byte[] a, int aoff, byte[] b, int boff, byte[] c, int coff, int l) {
        for (int i = 0; i < l; ++i) {
            c[coff + i] = (byte)((a[aoff + i] ^ b[boff + i]) & 0xFF);
        }
    }

    public final void MGF1(byte[] Z, int zoff, int zlen, byte[] mask, int moff, int l) {
        MessageDigest md;
        block10: {
            md = new SHA256();
            try {
                md = MessageDigest.getInstance(this.hashAlg, InitechProvider.NAME);
            }
            catch (Exception e) {
                if (md != null) break block10;
                try {
                    md = new SHA256();
                }
                catch (Exception ex) {
                    throw new RuntimeException("\uf9de????? ??? ???\u7531\u044a?????? " + this.hashAlg, ex);
                }
            }
        }
        int outlen = 0;
        byte[] cnt = new byte[4];
        if (mask.length < moff + l) {
            throw new RuntimeException("MGF1: too small mask");
        }
        int i = 0;
        while (outlen < l) {
            byte[] ret;
            cnt[0] = (byte)(i >> 24 & 0xFF);
            cnt[1] = (byte)(i >> 16 & 0xFF);
            cnt[2] = (byte)(i >> 8 & 0xFF);
            cnt[3] = (byte)(i & 0xFF);
            md.reset();
            try {
                md.update(Z, zoff, zlen);
                md.update(cnt);
                ret = md.digest();
            }
            catch (Exception e) {
                throw new RuntimeException("failed MGF1 cause of SHA256", e);
            }
            this.hLen = md.getDigestLength();
            if (outlen + this.hLen <= l) {
                System.arraycopy(ret, 0, mask, outlen + moff, this.hLen);
                outlen += this.hLen;
            } else {
                System.arraycopy(ret, 0, mask, outlen + moff, l - outlen);
                outlen = l;
            }
            ++i;
        }
    }

    public byte[] MGF1(byte[] Z, int zoff, int zlen, int l) {
        byte[] mask = new byte[l];
        this.MGF1(Z, zoff, zlen, mask, 0, l);
        return mask;
    }

    public byte[] _engineUpdate(byte[] input, int inputOffset, int inputLength) {
        int length = 0;
        byte[] out = new byte[this._engineGetOutputSize(inputLength)];
        try {
            length = this._engineUpdate(input, inputOffset, inputLength, out, 0);
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    public int _engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException {
        int sBufferLength = this.getBufferedDataLength();
        byte[] totalInput = new byte[inputLength + sBufferLength];
        this.getBufferedData(totalInput, 0);
        System.arraycopy(input, inputOffset, totalInput, sBufferLength, inputLength);
        int blockSize = this._engineGetBlockSize();
        int lastblockSize = totalInput.length % blockSize;
        int lastblockOffset = totalInput.length - lastblockSize;
        int outputLength = 0;
        try {
            if (this.cipherMode == 1) {
                for (int i = 0; i < lastblockOffset; i += blockSize) {
                    outputLength += this.encryptBlock(totalInput, i, blockSize, output, outputOffset + outputLength);
                }
            } else if (this.cipherMode == 2) {
                for (int i = 0; i < lastblockOffset; i += blockSize) {
                    outputLength += this.decryptBlock(totalInput, i, blockSize, output, outputOffset + outputLength);
                }
            }
        }
        catch (IllegalBlockSizeException e) {
            throw new ShortBufferException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new ShortBufferException(e.getMessage());
        }
        return outputLength;
    }

    public byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLength) throws IllegalBlockSizeException, BadPaddingException {
        int length = 0;
        byte[] out = new byte[this._engineGetOutputSize(inputLength)];
        length = this._engineDoFinal(input, inputOffset, inputLength, out, 0);
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    public int _engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        int sBufferLength = this.getBufferedDataLength();
        byte[] totalInput = new byte[inputLength + sBufferLength];
        int blockSize = this._engineGetBlockSize();
        this.getBufferedData(totalInput, 0);
        if (inputLength > 0) {
            System.arraycopy(input, inputOffset, totalInput, sBufferLength, inputLength);
        }
        int outputLength = 0;
        if (this.cipherMode == 1) {
            int i;
            int lastBlockLefts = totalInput.length % blockSize;
            for (i = 0; i < totalInput.length - lastBlockLefts; i += blockSize) {
                outputLength += this.encryptBlock(totalInput, i, blockSize, output, outputOffset + outputLength);
            }
            if (lastBlockLefts > 0) {
                outputLength += this.encryptBlock(totalInput, i, lastBlockLefts, output, outputOffset + outputLength);
            }
        } else if (this.cipherMode == 2) {
            for (int i = 0; i < totalInput.length; i += blockSize) {
                outputLength += this.decryptBlock(totalInput, i, blockSize, output, outputOffset + outputLength);
            }
        }
        return outputLength;
    }

    private final BigInteger crtProcess(BigInteger input) {
        BigInteger q2;
        RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)this.key;
        BigInteger d = rsaPrivateCrtKey.getPrivateExponent();
        BigInteger p = rsaPrivateCrtKey.getPrimeP();
        BigInteger q = rsaPrivateCrtKey.getPrimeQ();
        BigInteger dP = rsaPrivateCrtKey.getPrimeExponentP();
        BigInteger dQ = rsaPrivateCrtKey.getPrimeExponentQ();
        BigInteger qInv = rsaPrivateCrtKey.getCrtCoefficient();
        BigInteger p2 = input.mod(p).modPow(d.mod(p.subtract(ONE)), p);
        if (p2.equals(q2 = input.mod(q).modPow(d.mod(q.subtract(ONE)), q))) {
            return q2;
        }
        BigInteger k = p2.subtract(q2).mod(p).multiply(qInv).mod(p);
        return q.multiply(k).add(q2);
    }

    private String getVersion(byte[] plainText) {
        if (plainText[0] == 2) {
            int mLen;
            int i;
            for (i = 1; i < plainText.length && plainText[i] != 0; ++i) {
            }
            int psLen = i - 2;
            int k = this.engineGetBlockSize();
            if (psLen == k - (mLen = k - i - 1) - 3) {
                return "1.5";
            }
        }
        return "2.1";
    }
}

