/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.RijndaelKey;
import com.initech.provider.crypto.spec.RijndaelKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class RijndaelKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RijndaelKeySpec) {
            return new RijndaelKey(((RijndaelKeySpec)keySpec).getKey());
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            String alg = skspec.getAlgorithm();
            if (!alg.toUpperCase().startsWith("Rijndael") && !alg.toUpperCase().startsWith("AES")) {
                throw new InvalidKeySpecException("SecretKeySpec not for Rijndael");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            return new RijndaelKey(skspec.getEncoded());
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for Rijndael.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof RijndaelKey) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "Rijndael");
            }
            if (RijndaelKeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new RijndaelKeySpec(key.getEncoded());
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
        }
        throw new InvalidKeySpecException("not implemented");
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("Rijndael")) {
            throw new InvalidKeyException("not a Rijndael key");
        }
        return new RijndaelKey(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKey(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("Rijndael")) {
            throw new InvalidKeyException("not a Rijndael key");
        }
        return new RijndaelKey(key.getEncoded());
    }
}

