/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.SeedKey;
import com.initech.provider.crypto.spec.SeedKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SeedKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SeedKeySpec) {
            return new SeedKey(((SeedKeySpec)keySpec).getKey());
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            String alg = skspec.getAlgorithm();
            if (!(alg.toUpperCase().startsWith("SEED") || alg.toUpperCase().startsWith("SEEDX") || alg.toUpperCase().startsWith("SSSS"))) {
                throw new InvalidKeySpecException("SecretKeySpec not for SEED");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            return new SeedKey(skspec.getEncoded());
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for SEED.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof SeedKey) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "SEED");
            }
            if (SeedKeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new SeedKeySpec(key.getEncoded());
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
        }
        throw new InvalidKeySpecException("not implemented");
    }

    protected SecretKey engineTranslateKey(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("SEED")) {
            throw new InvalidKeyException("not a SEED key");
        }
        return new SeedKey(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKeyX(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("SEED")) {
            throw new InvalidKeyException("not a SEED key");
        }
        return new SeedKey(key.getEncoded());
    }
}

