/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.Cipher;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.ShortBufferException;
import com.initech.cryptox.spec.IvParameterSpec;
import com.initech.provider.crypto.cipher.CFBWrapper;
import com.initech.provider.crypto.cipher.OFBWrapper;
import com.initech.provider.crypto.cipher.Wrapper;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class StreamWrapper
extends Wrapper {
    private int blockSize = 0;

    public StreamWrapper(Cipher delegationCipher) {
        super(delegationCipher);
    }

    protected abstract byte encryptByte(byte var1);

    protected abstract byte decryptByte(byte var1);

    protected int encryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        throw new RuntimeException("Don't call me~~~");
    }

    protected int decryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        throw new RuntimeException("Don't call me~~~");
    }

    protected abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4, int var5);

    protected abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4, int var5);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherMode = opmode;
        this.random = random;
        if (params == null || params instanceof IvParameterSpec) {
            this.delegationCipher.init(1, key, random);
            if (params == null) return;
            this.blockSize = this.delegationCipher.getBlockSize();
            if (!(params instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("StreamWrapper receives only IvParameterSpec");
            this.iv = new byte[this.delegationCipher.getBlockSize()];
            System.arraycopy(((IvParameterSpec)params).getIV(), 0, this.iv, 0, this.blockSize);
            this.parameters = params;
            return;
        } else {
            this.delegationCipher.init(1, key, params, random);
            this.iv = this.delegationCipher.getIV();
            this.blockSize = this.delegationCipher.getBlockSize();
        }
    }

    protected int _engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length * 8;
    }

    protected int engineGetBlockSize(int inputLength) {
        return 1;
    }

    protected int _engineGetOutputSize(int inputLength) {
        return inputLength;
    }

    protected byte[] _engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] out = new byte[inputLen];
        try {
            this._engineUpdate(input, inputOffset, inputLen, out, 0);
        }
        catch (ShortBufferException e) {
            // empty catch block
        }
        return out;
    }

    protected int _engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int length = 0;
        try {
            length = this._engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
            // empty catch block
        }
        return length;
    }

    protected byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out = new byte[inputLen];
        this._engineDoFinal(input, inputOffset, inputLen, out, 0);
        return out;
    }

    protected int _engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        block29: {
            String modeName;
            block28: {
                modeName = Cipher.modeName;
                int bsize = 0;
                if (!(this instanceof CFBWrapper)) break block28;
                if (this.blockSize == 16) {
                    if (modeName.equalsIgnoreCase("CFB128")) {
                        bsize = 16;
                    } else if (modeName.equalsIgnoreCase("CFB64")) {
                        bsize = 8;
                    } else if (modeName.equalsIgnoreCase("CFB32")) {
                        bsize = 4;
                    } else if (modeName.equalsIgnoreCase("CFB16")) {
                        bsize = 2;
                    } else if (modeName.equalsIgnoreCase("CFB8")) {
                        bsize = 1;
                    } else if (modeName.equalsIgnoreCase("CFB")) {
                        bsize = 16;
                    }
                } else if (this.blockSize == 8) {
                    if (modeName.equalsIgnoreCase("CFB64")) {
                        bsize = 8;
                    } else if (modeName.equalsIgnoreCase("CFB32")) {
                        bsize = 4;
                    } else if (modeName.equalsIgnoreCase("CFB16")) {
                        bsize = 2;
                    } else if (modeName.equalsIgnoreCase("CFB8")) {
                        bsize = 1;
                    } else if (modeName.equalsIgnoreCase("CFB")) {
                        bsize = 8;
                    }
                }
                for (int i = 0; i < inputLen; i += bsize) {
                    if (this.cipherMode == 1) {
                        this.encryptBlock(input, i, output, outputOffset + i, bsize);
                        continue;
                    }
                    if (this.cipherMode != 2) continue;
                    this.decryptBlock(input, i, output, outputOffset + i, bsize);
                }
                break block29;
            }
            if (!(this instanceof OFBWrapper)) break block29;
            System.out.println("[*] modeName : " + modeName);
            if (modeName.equalsIgnoreCase("OFB") || modeName.equalsIgnoreCase("OFB128")) {
                for (int i = 0; i < inputLen; ++i) {
                    if (this.cipherMode == 1) {
                        output[outputOffset + i] = this.encryptByte(input[inputOffset + i]);
                        continue;
                    }
                    if (this.cipherMode != 2) continue;
                    output[outputOffset + i] = this.decryptByte(input[inputOffset + i]);
                }
            }
        }
        return inputLen;
    }

    protected void shiftBuffer(byte fill) {
        for (int i = 0; i < this.blockSize - 1; ++i) {
            this.iv[i] = this.iv[i + 1];
        }
        this.iv[this.blockSize - 1] = fill;
    }

    protected void shiftBuffer(byte[] input, int inputOff, int bsize) {
        int i;
        for (i = 0; i < this.blockSize - bsize; ++i) {
            this.iv[i] = this.iv[i + bsize];
        }
        for (i = this.blockSize - bsize; i < this.blockSize; ++i) {
            this.iv[i] = input[inputOff++];
        }
    }
}

