/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.Cipher;
import com.initech.cryptox.CipherSpi;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.cryptox.spec.IvParameterSpec;
import com.initech.provider.AutoJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;

public abstract class Wrapper
extends CipherSpi {
    protected Cipher delegationCipher;
    protected int blockSize;
    protected byte[] iv;
    protected byte[] originalIV;
    protected AlgorithmParameterSpec parameters;
    protected SecureRandom random = null;
    protected int cipherMode = 0;
    protected Key key;

    public Wrapper(Cipher delegationCipher) {
        this.delegationCipher = delegationCipher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherMode = opmode;
        this.random = random;
        this.key = key;
        if ((params = (AlgorithmParameterSpec)AutoJCE.toJCEX(params)) == null || params instanceof javax.crypto.spec.IvParameterSpec || params instanceof IvParameterSpec) {
            this.delegationCipher.init(opmode, key, random);
            if (params != null) {
                int blockSize = this.delegationCipher.getBlockSize();
                if (!(params instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Wrapper receives only IvParameterSpec");
                this.iv = new byte[blockSize];
                try {
                    System.arraycopy(((IvParameterSpec)params).getIV(), 0, this.iv, 0, blockSize);
                    this.originalIV = (byte[])this.iv.clone();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new InvalidAlgorithmParameterException("Given initial vector is too short");
                }
                this.parameters = params;
            }
        } else {
            this.delegationCipher.init(opmode, key, params, random);
            this.iv = this.delegationCipher.getIV();
            this.originalIV = (byte[])this.iv.clone();
        }
        this.blockSize = this.delegationCipher.getBlockSize();
    }

    protected void _engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.key = key;
        try {
            this._engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("Wrapper: InvalidAlgorithmParameterException: " + e.getMessage());
        }
        this.iv = new byte[this.blockSize];
        random.nextBytes(this.iv);
        this.originalIV = (byte[])this.iv.clone();
    }

    protected void _engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.key = key;
        javax.crypto.spec.IvParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(javax.crypto.spec.IvParameterSpec.class);
            }
            catch (Exception e) {
                try {
                    this.cipherMode = opmode;
                    this.random = random;
                    this.delegationCipher.init(opmode, key, params, random);
                    this.iv = this.delegationCipher.getIV();
                    this.originalIV = (byte[])this.iv.clone();
                }
                catch (Exception ee) {
                    throw new InvalidAlgorithmParameterException("Wrapper: IvParameterSpec convert error: " + e + "|" + ee);
                }
            }
        }
        this._engineInit(opmode, key, spec, random);
    }

    protected byte[] _engineGetIV() {
        return (byte[])this.originalIV.clone();
    }

    protected int _engineGetOutputSize(int inputLen) {
        return this.delegationCipher.getOutputSize(inputLen);
    }

    protected int _engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] k = key.getEncoded();
        return k.length * 8;
    }

    protected int _engineGetBlockSize() {
        return this.blockSize;
    }

    protected byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, BadPaddingException, IllegalBlockSizeException {
        if (this.originalIV != null) {
            this.iv = (byte[])this.originalIV.clone();
        }
        return this.delegationCipher.doFinal(input, inputOffset, inputLen);
    }

    protected int _engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalArgumentException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.originalIV != null) {
            this.iv = (byte[])this.originalIV.clone();
        }
        try {
            return this.delegationCipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
        }
        catch (com.initech.cryptox.ShortBufferException e) {
            throw new IllegalBlockSizeException(e.toString());
        }
    }

    protected AlgorithmParameters _engineGetParameters() {
        throw new RuntimeException("Not implemented....");
    }

    protected byte[] _engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.delegationCipher.update(input, inputOffset, inputLen);
    }

    protected int _engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalArgumentException, ShortBufferException {
        return this.delegationCipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    protected void _engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (!paddingName.equals("NoPadding") && paddingName != null) {
            throw new NoSuchPaddingException("This is NoPadding mode. Cannot change to " + paddingName);
        }
    }

    protected void _engineSetMode(String modeName) throws NoSuchAlgorithmException {
        if (!modeName.equals("ECB") && !modeName.equals("")) {
            throw new NoSuchAlgorithmException("This is ECB mode. Cannot change to " + modeName);
        }
    }
}

