/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher.jni;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.CipherSpi;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.cryptox.SecretKey;
import com.initech.cryptox.ShortBufferException;
import com.initech.cryptox.spec.IvParameterSpec;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class NativeBlockCipher
extends CipherSpi {
    private int mode;
    private int blockSize;
    private byte[] key;
    private byte[] iv;
    private String ciphername;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private SecureRandom random;
    private AlgorithmParameterSpec parameters;

    public NativeBlockCipher(String name, int blksize) {
        this.ciphername = name;
        this.blockSize = blksize;
    }

    protected void _engineSetMode(String mode) throws NoSuchAlgorithmException {
    }

    protected void _engineSetPadding(String padding) throws NoSuchPaddingException {
    }

    protected int _engineGetBlockSize() {
        return this.blockSize;
    }

    protected int _engineGetOutputSize(int inputLen) {
        int s = this.baos.size();
        if ((s += inputLen) % this.blockSize == 0) {
            s += this.blockSize;
        } else {
            while (s % this.blockSize != 0) {
                ++s;
            }
        }
        return s;
    }

    protected byte[] _engineGetIV() {
        return this.iv;
    }

    protected AlgorithmParameters _engineGetParameters() {
        return null;
    }

    protected final void _engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("NativeBlockCipher: InvalidAlgorithmParameterException: " + e.getMessage());
        }
    }

    protected final void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.mode = opmode == 1 ? 1 : 0;
        this.random = random;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException();
        }
        if (this.key != null) {
            for (int i = 0; i < this.key.length; ++i) {
                this.key[i] = 0;
            }
        }
        this.key = key.getEncoded();
        if (params != null) {
            if (params instanceof IvParameterSpec) {
                this.iv = new byte[this.blockSize];
                try {
                    System.arraycopy(((IvParameterSpec)params).getIV(), 0, this.iv, 0, this.blockSize);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new InvalidAlgorithmParameterException("Given initial vector is too short");
                }
            } else {
                throw new InvalidAlgorithmParameterException("NativeBlockCipher receives only IvParameterSpec");
            }
            this.parameters = params;
        } else {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.iv = new byte[this.blockSize];
            this.random.nextBytes(this.iv);
            this.parameters = new IvParameterSpec(this.iv);
        }
    }

    protected final void _engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(IvParameterSpec.class);
            }
            catch (Exception ignore) {
                spec = null;
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    protected final byte[] _engineUpdate(byte[] input, int inputOff, int inputLen) {
        this.baos.write(input, inputOff, inputLen);
        return null;
    }

    protected final int _engineUpdate(byte[] input, int inputOff, int inputLen, byte[] output, int outputOff) throws ShortBufferException {
        try {
            this.baos.write(input, inputOff, inputLen);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return 0;
    }

    private static native void cipherInit();

    private native int dofinalBuffer(int var1, String var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, int var7);

    private native byte[] dofinal(int var1, String var2, byte[] var3, byte[] var4, byte[] var5);

    protected final byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        this.baos.write(input, inputOffset, inputLen);
        byte[] d = this.baos.toByteArray();
        this.baos.reset();
        return this.dofinal(this.mode, this.ciphername, this.key, this.iv, d);
    }

    protected final int _engineDoFinal(byte[] input, int inputOff, int inputLen, byte[] output, int outputOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.baos.write(input, inputOff, inputLen);
        byte[] d = this.baos.toByteArray();
        this.baos.reset();
        return this.dofinalBuffer(this.mode, this.ciphername, this.key, this.iv, d, output, outputOff);
    }

    protected void finalize() throws Throwable {
        if (this.key != null) {
            for (int i = 0; i < this.key.length; ++i) {
                this.key[i] = 0;
            }
        }
        this.key = null;
        if (this.baos != null) {
            this.baos.close();
        }
        this.baos = null;
    }

    static {
        System.loadLibrary("inijce");
        NativeBlockCipher.cipherInit();
    }
}

