/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.cryptox.KeyAgreementSpi;
import com.initech.cryptox.SecretKeyFactory;
import com.initech.cryptox.ShortBufferException;
import com.initech.cryptox.interfaces.DHPrivateKey;
import com.initech.cryptox.interfaces.DHPublicKey;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.crypto.InitechProvider;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;

public class DHKeyAgreement
extends KeyAgreementSpi {
    private DHPrivateKey privkey;
    private DHPublicKey pubkey;
    private BigInteger P;
    private BigInteger G;
    private SecureRandom random;
    private boolean ready = false;

    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("this key is not DHPublicKey");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Diffie-Hellman is not multi-phase algorithm");
        }
        this.pubkey = (DHPublicKey)key;
        if (this.P.compareTo(this.pubkey.getParams().getP()) != 0 || this.G.compareTo(this.pubkey.getParams().getG()) != 0) {
            this.pubkey = null;
            throw new InvalidKeyException("this key is invalid P or G");
        }
        this.ready = true;
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.ready) {
            throw new IllegalStateException("not initiated");
        }
        BigInteger X = this.privkey.getX();
        BigInteger Y = this.pubkey.getY();
        BigInteger ZZ = Y.modPow(X, this.P);
        this.ready = false;
        byte[] zz = ZZ.toByteArray();
        if (zz[0] == 0) {
            byte[] t = new byte[zz.length - 1];
            System.arraycopy(zz, 1, t, 0, t.length);
            zz = t;
        }
        return zz;
    }

    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws ShortBufferException, IllegalStateException {
        if (sharedSecret == null) {
            throw new ShortBufferException("sharedSecret is null");
        }
        byte[] ret = this.engineGenerateSecret();
        if (sharedSecret.length < ret.length + offset) {
            throw new ShortBufferException("key Length is " + ret.length + " but sharedSecret is " + sharedSecret.length + " and offset is " + offset);
        }
        System.arraycopy(ret, 0, sharedSecret, offset, ret.length);
        return ret.length;
    }

    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] k = this.engineGenerateSecret();
        if (k == null) {
            throw new InvalidKeyException();
        }
        try {
            SecretKeySpec skspec = new SecretKeySpec(k, algorithm);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm, InitechProvider.NAME);
            return skf.generateSecret(skspec);
        }
        catch (InvalidKeySpecException ex) {
            throw new InvalidKeyException();
        }
        catch (NoSuchProviderException e) {
            throw new InvalidKeyException();
        }
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(key, random);
    }

    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("this key is not DHPrivateKey");
        }
        this.random = random;
        this.privkey = (DHPrivateKey)key;
        this.P = this.privkey.getParams().getP();
        this.G = this.privkey.getParams().getG();
        this.ready = false;
    }
}

