/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.cryptox.interfaces.DHPrivateKey;
import com.initech.cryptox.interfaces.DHPublicKey;
import com.initech.cryptox.spec.DHPublicKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.dh.DHPrivateKeyImpl;
import com.initech.provider.crypto.dh.DHPublicKeyImpl;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;

public class DHKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPrivateKeySpec) {
                keySpec = (com.initech.cryptox.spec.DHPrivateKeySpec)AutoJCE.toJCEX(keySpec);
                com.initech.cryptox.spec.DHPrivateKeySpec privKeySpec = (com.initech.cryptox.spec.DHPrivateKeySpec)keySpec;
                return new DHPrivateKeyImpl(privKeySpec.getX(), privKeySpec.getP(), privKeySpec.getG());
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DHPrivateKeyImpl(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Bad key specification");
        }
        catch (Exception e) {
            throw new InvalidKeySpecException("Bad key specification");
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof javax.crypto.spec.DHPublicKeySpec) {
                keySpec = (DHPublicKeySpec)AutoJCE.toJCEX(keySpec);
                DHPublicKeySpec pubKeySpec = (DHPublicKeySpec)keySpec;
                return new DHPublicKeyImpl(pubKeySpec.getY(), pubKeySpec.getP(), pubKeySpec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DHPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Bad key specification");
        }
        catch (Exception e) {
            throw new InvalidKeySpecException("Bad key specification");
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (key instanceof DHPublicKey) {
            if (DHPublicKeySpec.class.isAssignableFrom(spec)) {
                DHPublicKey dh = (DHPublicKey)key;
                DHParameterSpec params = dh.getParams();
                return new DHPublicKeySpec(dh.getY(), params.getP(), params.getG());
            }
            if (X509EncodedKeySpec.class.isAssignableFrom(spec)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
        } else if (key instanceof DHPrivateKey) {
            if (com.initech.cryptox.spec.DHPrivateKeySpec.class.isAssignableFrom(spec)) {
                DHPrivateKey dh = (DHPrivateKey)key;
                DHParameterSpec params = dh.getParams();
                return new com.initech.cryptox.spec.DHPrivateKeySpec(dh.getX(), params.getP(), params.getG());
            }
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(spec)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
        }
        throw new InvalidKeySpecException("Invalid Key or KeySpec.");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }
}

