/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.cryptox.spec.DHParameterSpec;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.dh.DHPrivateKeyImpl;
import com.initech.provider.crypto.dh.DHPublicKeyImpl;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    private BigInteger y = null;
    private BigInteger x = null;
    private BigInteger p = null;
    private BigInteger g = null;
    private int primeSize = 512;
    private int exponentSize = 504;
    private SecureRandom random = null;
    private boolean genParam = false;

    public DHKeyPairGenerator() {
        super("DH");
    }

    public KeyPair generateKeyPair() {
        Object keyPair = null;
        if (this.exponentSize == 0) {
            this.exponentSize = this.primeSize - 1;
        }
        if (this.p == null || this.g == null || this.genParam) {
            AlgorithmParameterGenerator apg;
            try {
                apg = AlgorithmParameterGenerator.getInstance("DH", InitechProvider.NAME);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("generator uninitialised");
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException("Initech Provider is not properly initialized");
            }
            apg.init(this.primeSize, this.random);
            try {
                DHParameterSpec spec = apg.generateParameters().getParameterSpec(DHParameterSpec.class);
                this.p = spec.getP();
                this.g = spec.getG();
            }
            catch (InvalidParameterSpecException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.x = new BigInteger(this.exponentSize, this.random);
        this.y = this.g.modPow(this.x, this.p);
        try {
            return new KeyPair(new DHPublicKeyImpl(this.y, this.p, this.g, this.exponentSize), new DHPrivateKeyImpl(this.x, this.p, this.g, this.exponentSize));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void initialize(int primeSize) {
        this.primeSize = primeSize;
        this.exponentSize = 0;
        this.random = new SecureRandom();
        this.genParam = true;
    }

    public void initialize(int primeSize, SecureRandom random) {
        this.primeSize = primeSize;
        this.exponentSize = 0;
        this.random = random;
        this.genParam = true;
    }

    public void initialize(AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(spec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Bad parameter spec");
        }
        this.random = random;
        this.p = ((DHParameterSpec)spec).getP();
        this.g = ((DHParameterSpec)spec).getG();
        this.genParam = false;
        this.primeSize = this.p.bitLength();
        this.exponentSize = ((DHParameterSpec)spec).getL();
        if (this.exponentSize != 0 && this.exponentSize >= this.primeSize) {
            throw new InvalidAlgorithmParameterException("Exponent must be smaller than modulus");
        }
    }

    protected void engineZeroize() {
        if (this.y != null) {
            this.y = BigInteger.ZERO;
        }
        if (this.x != null) {
            this.x = BigInteger.ZERO;
        }
        if (this.p != null) {
            this.p = BigInteger.ZERO;
        }
        if (this.g != null) {
            this.g = BigInteger.ZERO;
        }
        if (this.random != null) {
            this.random = null;
        }
    }
}

