/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.cryptox.spec.DHGenParameterSpec;
import com.initech.cryptox.spec.DHParameterSpec;
import com.initech.provider.crypto.InitechProvider;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SecureRandom random;
    private int keyLength = 1024;
    private int expSize = 512;

    protected void engineInit(int strength, SecureRandom random) {
        this.keyLength = strength;
        this.random = random;
    }

    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported param spec");
        }
        this.random = random;
        this.expSize = ((DHGenParameterSpec)genParamSpec).getExponentSize();
        this.keyLength = ((DHGenParameterSpec)genParamSpec).getPrimeSize();
    }

    protected AlgorithmParameters engineGenerateParameters() {
        try {
            AlgorithmParameterGenerator gen = AlgorithmParameterGenerator.getInstance("DSA", InitechProvider.NAME);
            gen.init(this.keyLength, this.random);
            AlgorithmParameters dsaParams = gen.generateParameters();
            DSAParameterSpec dsaSpec = dsaParams.getParameterSpec(DSAParameterSpec.class);
            DHParameterSpec dhSpec = new DHParameterSpec(dsaSpec.getP(), dsaSpec.getG(), this.expSize);
            AlgorithmParameters algParams = AlgorithmParameters.getInstance("DH", InitechProvider.NAME);
            algParams.init(dhSpec);
            return algParams;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

