/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.cryptox.spec.DHParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DHParameters
extends AlgorithmParametersSpi {
    protected BigInteger P;
    protected BigInteger G;
    protected int l = 0;

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return new DHParameterData(this.P, this.G, this.l).getEncoded();
        }
        catch (ASN1Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    protected byte[] engineGetEncoded(String s) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        try {
            Class<?> paramSpec2 = Class.forName("javax.crypto.spec.DHParameterSpec");
            if (paramSpec2.isAssignableFrom(paramSpec)) {
                return new DHParameterSpec(this.P, this.G, this.l);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.P = ((DHParameterSpec)paramSpec).getP();
        this.G = ((DHParameterSpec)paramSpec).getG();
        this.l = ((DHParameterSpec)paramSpec).getL();
    }

    protected void engineInit(byte[] params) throws IOException {
        try {
            DHParameterData paramData = new DHParameterData(params);
            this.P = paramData.getP();
            this.G = paramData.getG();
            this.l = paramData.getL();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected void engineInit(byte[] params, String s) throws IOException {
        this.engineInit(params);
    }

    protected String engineToString() {
        return "\n\tp: " + this.P.toString() + "\n\tl: " + this.l + "\n\tg: " + this.G.toString() + "\n";
    }

    public class DHParameterData
    extends ASN1Object {
        private BigInteger P = null;
        private BigInteger G = null;
        private BigInteger L = null;

        public DHParameterData() {
        }

        public DHParameterData(BigInteger P, BigInteger G, int l) {
            this.P = P;
            this.G = G;
            if (l != 0) {
                this.L = BigInteger.valueOf(l);
            }
            this.modified = true;
        }

        protected DHParameterData(byte[] byteArray) throws ASN1Exception {
            DERDecoder dec = new DERDecoder(byteArray);
            this.decode(dec);
            this.encoded = (byte[])byteArray.clone();
            this.modified = false;
        }

        public void setP(BigInteger P) {
            this.modified = true;
            this.P = P;
        }

        public void setG(BigInteger G) {
            this.modified = true;
            this.G = G;
        }

        public void setL(BigInteger L) {
            this.modified = true;
            this.L = L;
        }

        public BigInteger getP() {
            return this.P;
        }

        public int getL() {
            return this.L.intValue();
        }

        public BigInteger getG() {
            return this.G;
        }

        public void decode(ASN1Decoder dec) throws ASN1Exception {
            int id = dec.decodeSequence();
            this.P = dec.decodeInteger();
            this.G = dec.decodeInteger();
            this.L = dec.nextIsOptional(2) ? new BigInteger("0") : dec.decodeInteger();
            if (!dec.nextIsOptional(2)) {
                dec.decodeInteger();
            }
            if (!dec.nextIsOptional(16)) {
                int id2 = dec.decodeSequence();
                dec.decodeBitString();
                dec.decodeInteger();
                dec.endOf(id2);
            }
            dec.endOf(id);
        }

        public void encode(ASN1Encoder enc) throws ASN1Exception {
            int id = enc.encodeSequence();
            enc.encodeInteger(this.P);
            enc.encodeInteger(this.G);
            if (this.L != null && this.L.intValue() != 0) {
                enc.encodeInteger(this.L);
            }
            enc.endOf(id);
        }
    }
}

