/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.cryptox.interfaces.DHPrivateKey;
import com.initech.cryptox.spec.DHParameterSpec;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import com.initech.provider.crypto.InitechProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;

public final class DHPrivateKeyImpl
implements DHPrivateKey {
    private static final long serialVersionUID = 6805645474027785630L;
    private BigInteger X;
    private DHParameterSpec spec;
    private PrivateKeyInfo pkinfo = new PrivateKeyInfo();
    private boolean modified = false;

    public DHPrivateKeyImpl() {
    }

    public DHPrivateKeyImpl(BigInteger X, BigInteger P, BigInteger G, int l) throws InvalidKeyException {
        this.X = X;
        this.spec = new DHParameterSpec(P, G, l);
        this.modified = true;
    }

    public DHPrivateKeyImpl(BigInteger X, BigInteger P, BigInteger G) throws InvalidKeyException {
        this.X = X;
        this.spec = new DHParameterSpec(P, G, 0);
        this.modified = true;
    }

    public DHPrivateKeyImpl(byte[] privkey) throws InvalidKeyException {
        try {
            this.pkinfo = new PrivateKeyInfo(privkey);
            if (!this.pkinfo.getAlgorithm().equals("1.2.840.10046.2.1")) {
                throw new InvalidKeyException("this algorithm is not DH");
            }
            AlgorithmParameters ap = AlgorithmParameters.getInstance("DH", InitechProvider.NAME);
            ap.init(this.pkinfo.getParameters());
            this.spec = ap.getParameterSpec(DHParameterSpec.class);
            DERDecoder dec = new DERDecoder(this.pkinfo.getPrivateKey());
            this.X = dec.decodeInteger();
            this.modified = true;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public javax.crypto.spec.DHParameterSpec getParams() {
        return this.spec;
    }

    public BigInteger getX() {
        return this.X;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.pkinfo.getEncoded();
            }
            AlgorithmParameters param = AlgorithmParameters.getInstance("DH", InitechProvider.NAME);
            param.init(this.spec);
            this.pkinfo.setPrivateKeyAlgorithm(new AlgorithmID("1.2.840.10046.2.1", param.getEncoded()));
            DEREncoder enc = new DEREncoder();
            enc.encodeInteger(this.X);
            byte[] key = enc.toByteArray();
            this.pkinfo.setPrivateKey(key);
            byte[] ret = this.pkinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DHPrivateKey)) {
            return false;
        }
        DHPrivateKey p = (DHPrivateKey)o;
        javax.crypto.spec.DHParameterSpec pa = p.getParams();
        if (!this.spec.getP().equals(pa.getP())) {
            return false;
        }
        if (!this.spec.getG().equals(pa.getG())) {
            return false;
        }
        return this.X.equals(p.getX());
    }

    public int hashCode() {
        if (this.X == null) {
            return 0;
        }
        return this.X.hashCode();
    }
}

