/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.cryptox.interfaces.DHPublicKey;
import com.initech.cryptox.spec.DHParameterSpec;
import com.initech.provider.crypto.InitechProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;

public final class DHPublicKeyImpl
implements DHPublicKey {
    private static final long serialVersionUID = -589745785165432949L;
    private BigInteger Y;
    private javax.crypto.spec.DHParameterSpec spec;
    private PublicKeyInfo kinfo;
    private boolean modified = false;

    public DHPublicKeyImpl() {
        this.kinfo = new PublicKeyInfo();
        this.modified = true;
    }

    public DHPublicKeyImpl(BigInteger Y, DHParameterSpec spec) {
        this.Y = Y;
        this.spec = spec;
        this.kinfo = new PublicKeyInfo();
        this.modified = true;
    }

    public DHPublicKeyImpl(BigInteger Y, BigInteger P, BigInteger G, int l) throws InvalidKeyException {
        this.Y = Y;
        this.spec = new DHParameterSpec(P, G, l);
        this.kinfo = new PublicKeyInfo();
        this.modified = true;
    }

    public DHPublicKeyImpl(BigInteger Y, BigInteger P, BigInteger G) throws InvalidKeyException {
        this.Y = Y;
        this.spec = new DHParameterSpec(P, G, 0);
        this.modified = true;
    }

    public DHPublicKeyImpl(byte[] pubkey) throws InvalidKeyException {
        try {
            this.kinfo = new PublicKeyInfo(pubkey);
            if (!this.kinfo.getAlg().equals("1.2.840.10046.2.1")) {
                throw new InvalidKeyException("this algorithm is not DH");
            }
            AlgorithmParameters ap = AlgorithmParameters.getInstance("DH", InitechProvider.NAME);
            ap.init(this.kinfo.getAlgParameter());
            this.spec = ap.getParameterSpec(DHParameterSpec.class);
            DERDecoder dec = new DERDecoder(this.kinfo.getPublicKeyAsByteArray());
            this.Y = dec.decodeInteger();
            this.modified = true;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public javax.crypto.spec.DHParameterSpec getParams() {
        return this.spec;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.kinfo.getEncoded();
            }
            AlgorithmParameters param = AlgorithmParameters.getInstance("DH", InitechProvider.NAME);
            param.init(this.spec);
            this.kinfo.setAlgName("1.2.840.10046.2.1");
            this.kinfo.setAlgParameter(param.getEncoded());
            DEREncoder enc = new DEREncoder();
            enc.encodeInteger(this.Y);
            byte[] key = enc.toByteArray();
            this.kinfo.setPublicKey(key);
            byte[] ret = this.kinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DHPublicKey)) {
            return false;
        }
        DHPublicKey p = (DHPublicKey)o;
        javax.crypto.spec.DHParameterSpec pa = p.getParams();
        if (!this.spec.getP().equals(pa.getP())) {
            return false;
        }
        if (!this.spec.getG().equals(pa.getG())) {
            return false;
        }
        return this.Y.equals(p.getY());
    }

    public int hashCode() {
        if (this.Y == null) {
            return 0;
        }
        return this.Y.hashCode();
    }
}

