/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.asn1.OIDDictionary;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.dh.DHKeyAgreement;
import com.initech.provider.crypto.dh.KeySpecificInfo;
import com.initech.provider.crypto.dh.OtherInfo;
import com.initech.provider.crypto.spec.ESDHParameter;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class ESDHKeyAgreement
extends DHKeyAgreement {
    private String algorithm;
    private int keyLength = 24;
    private byte[] ukm;

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] zz = super.engineGenerateSecret();
        String oid = OIDDictionary.getOIDbyName(this.algorithm);
        if (oid == null) {
            throw new IllegalStateException("a OID of this algorithm is not founded");
        }
        int round = (this.keyLength + 20) / 20;
        byte[] ret = new byte[(round - 1) * 20];
        for (int i = 1; i < round; ++i) {
            KeySpecificInfo ksi = new KeySpecificInfo();
            ksi.setAlgorithm(oid);
            ksi.setCounter(new BigInteger(Integer.toString(i)));
            OtherInfo oi = new OtherInfo();
            oi.setKeyInfo(ksi);
            if (this.ukm != null) {
                oi.setPartyAInfo(this.ukm);
            }
            oi.setSuppPubInfo(new BigInteger(Integer.toString(this.keyLength * 8)));
            byte[] otherInfo = null;
            byte[] roundHash = null;
            try {
                otherInfo = oi.getEncoded();
                MessageDigest md = MessageDigest.getInstance("SHA1", InitechProvider.NAME);
                md.update(zz);
                md.update(otherInfo);
                roundHash = md.digest();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.arraycopy(roundHash, 0, ret, 20 * (i - 1), 20);
        }
        return ret;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(params instanceof ESDHParameter)) {
            throw new InvalidAlgorithmParameterException("params is not ESDHParameter");
        }
        if (params != null) {
            ESDHParameter p = (ESDHParameter)params;
            this.algorithm = p.getAlgorithm();
            this.keyLength = p.getKeyLength();
            if (p.getUKM() != null) {
                this.ukm = p.getUKM();
            }
        }
        super.engineInit(key, random);
    }
}

