/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.useful.ASN1Object;
import java.math.BigInteger;

public class KeySpecificInfo
extends ASN1Object {
    private static final long serialVersionUID = -3556580766072187434L;
    private ASN1OID algorithm = new ASN1OID();
    private byte[] counter = null;

    public void setAlgorithm(String algName) {
        this.modified = true;
        this.algorithm.set(algName);
    }

    public void setAlgorithm(ASN1OID alg) {
        this.modified = true;
        this.algorithm.set(alg);
    }

    public String getAlgorithm() {
        return this.algorithm.get();
    }

    public void setCounter(BigInteger counter) {
        byte[] c = new byte[4];
        byte[] cc = counter.toByteArray();
        if (cc.length > c.length) {
            System.arraycopy(cc, cc.length - c.length, c, 0, c.length);
        } else {
            System.arraycopy(cc, 0, c, c.length - cc.length, cc.length);
        }
        this.counter = c;
        this.modified = true;
    }

    public BigInteger getCounter() {
        return new BigInteger(0, this.counter);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeObjectIdentifier(this.algorithm);
        enc.encodeOctetString(this.counter);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.algorithm = dec.decodeObjectIdentifier();
        this.counter = dec.decodeOctetString();
        dec.endOf(id);
    }
}

