/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dh;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.useful.ASN1Object;
import com.initech.provider.crypto.dh.KeySpecificInfo;
import java.math.BigInteger;

public class OtherInfo
extends ASN1Object {
    private static final long serialVersionUID = -334141237407833501L;
    KeySpecificInfo keyInfo = new KeySpecificInfo();
    byte[] partyAInfo = null;
    byte[] suppPubInfo = null;

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id2;
        int id = enc.encodeSequence();
        enc.encodeAny(this.keyInfo.getEncoded());
        if (this.partyAInfo != null) {
            id2 = enc.encodeExplicit(0);
            enc.encodeOctetString(this.partyAInfo);
            enc.endOf(id2);
        }
        id2 = enc.encodeExplicit(ASN1Tag.makeContextTag(2));
        enc.encodeOctetString(this.suppPubInfo);
        enc.endOf(id2);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id2;
        int id = dec.decodeSequence();
        this.keyInfo.decode(dec);
        if (dec.nextIsOptional(ASN1Tag.makeExplicitTag(0))) {
            this.partyAInfo = null;
        } else {
            id2 = dec.decodeExplicit(ASN1Tag.makeExplicitTag(0));
            this.partyAInfo = dec.decodeOctetString();
            dec.endOf(id2);
        }
        id2 = dec.decodeExplicit(ASN1Tag.makeExplicitTag(2));
        this.suppPubInfo = dec.decodeOctetString();
        dec.endOf(id2);
        dec.endOf(id);
    }

    public void setKeyInfo(KeySpecificInfo keyInfo) {
        this.modified = true;
        this.keyInfo.setAlgorithm(keyInfo.getAlgorithm());
        this.keyInfo.setCounter(keyInfo.getCounter());
    }

    public KeySpecificInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setPartyAInfo(byte[] partyAInfo) {
        this.partyAInfo = (byte[])(partyAInfo == null ? null : (byte[])partyAInfo.clone());
    }

    public byte[] getPartyAInfo() {
        return (byte[])this.partyAInfo.clone();
    }

    public void setSuppPubInfo(BigInteger suppPubInfo) {
        byte[] c = new byte[4];
        byte[] cc = suppPubInfo.toByteArray();
        if (cc.length > c.length) {
            System.arraycopy(cc, cc.length - c.length, c, 0, c.length);
        } else {
            System.arraycopy(cc, 0, c, c.length - cc.length, cc.length);
        }
        this.suppPubInfo = c;
        this.modified = true;
    }

    public BigInteger getSuppPubInfo() {
        if (this.suppPubInfo == null) {
            return null;
        }
        return new BigInteger(this.suppPubInfo);
    }
}

