/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dsa;

import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.dsa.DSASignedData;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DSA
extends Signature {
    private MessageDigest dataSeed;
    private DSAParams params;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    private BigInteger presetY;
    private BigInteger presetX;
    private SecureRandom signingRandom;
    private SecureRandom appRandom;
    protected String hashAlgorithm;
    private byte[] certData;

    public DSA(String hashAlgorithm) throws NoSuchAlgorithmException {
        super(hashAlgorithm + "withDSA");
        this.hashAlgorithm = hashAlgorithm;
        try {
            this.dataSeed = MessageDigest.getInstance(hashAlgorithm, InitechProvider.NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(hashAlgorithm + " is not supported");
        }
        this.certData = null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        DSAPrivateKey dsaPrivateKey = (DSAPrivateKey)privateKey;
        this.presetX = dsaPrivateKey.getX();
        this.initialize(dsaPrivateKey.getParams());
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
        this.appRandom = random;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
        this.presetY = dsaPublicKey.getY();
        this.initialize(dsaPublicKey.getParams());
    }

    protected void engineSetParameter(String s, Object obj) throws InvalidParameterException {
        throw new InvalidParameterException("this method is depecated.");
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DSAParams)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.setParams((DSAParams)((Object)params));
    }

    protected Object engineGetParameter(String params) throws InvalidParameterException {
        throw new InvalidParameterException("this method is depecated.");
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            BigInteger H = this.generateH();
            BigInteger K = this.generateK(this.presetQ);
            BigInteger R = this.generateR(this.presetG, K, this.presetP, this.presetQ);
            BigInteger S = this.generateS(K, H, this.presetX, R, this.presetQ);
            DSASignedData sd = new DSASignedData(R, S);
            return sd.getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] sbyte;
        BigInteger H = this.generateH();
        BigInteger K = this.generateK(this.presetQ);
        BigInteger R = this.generateR(this.presetG, K, this.presetP, this.presetQ);
        BigInteger S = this.generateS(K, H, this.presetX, R, this.presetQ);
        byte[] rbyte = R.toByteArray();
        if (rbyte.length + (sbyte = S.toByteArray()).length > outbuf.length - offset) {
            throw new SignatureException("buffer length is too short");
        }
        if (outbuf == null) {
            throw new SignatureException("buffer is null");
        }
        try {
            DSASignedData sd = new DSASignedData(R, S);
            byte[] ret = sd.getEncoded();
            System.arraycopy(outbuf, offset, ret, 0, ret.length);
            return ret.length;
        }
        catch (Exception e) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected void engineUpdate(byte b) throws SignatureException {
        try {
            this.dataSeed.update(b);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        try {
            this.dataSeed.update(b, off, len);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger RR = null;
        BigInteger SS = null;
        try {
            DSASignedData sd = new DSASignedData(sigBytes);
            RR = sd.getR();
            SS = sd.getS();
        }
        catch (Exception e) {
            throw new SignatureException("invalid encoding for signature");
        }
        BigInteger HH = this.generateH();
        BigInteger W = this.generateW(SS, this.presetQ);
        BigInteger U1 = this.generateU(HH, W, this.presetQ);
        BigInteger U2 = this.generateU(RR, W, this.presetQ);
        BigInteger V = this.generateV(this.presetG, U1, this.presetY, U2, this.presetP, this.presetQ);
        return this.isEqual(RR, V);
    }

    private boolean isEqual(BigInteger W, BigInteger R) {
        return R.compareTo(W) == 0;
    }

    private BigInteger generateK(BigInteger Q) {
        BigInteger intBig;
        byte[] rand = new byte[20];
        SecureRandom sr = this.getSigningRandom();
        do {
            this.signingRandom.nextBytes(rand);
        } while ((intBig = new BigInteger(1, rand)).compareTo(Q) != -1 || intBig.compareTo(new BigInteger("0")) == 0);
        return intBig;
    }

    private BigInteger generateW(BigInteger S, BigInteger Q) {
        return S.modInverse(Q);
    }

    private BigInteger generateU(BigInteger A, BigInteger W, BigInteger Q) {
        BigInteger int1 = A.multiply(W);
        return int1.mod(Q);
    }

    private BigInteger generateV(BigInteger G, BigInteger U1, BigInteger Y, BigInteger U2, BigInteger P, BigInteger Q) {
        BigInteger int1 = G.modPow(U1, P);
        BigInteger int2 = Y.modPow(U2, P);
        return int1.multiply(int2).mod(P).mod(Q);
    }

    private BigInteger generateR(BigInteger G, BigInteger K, BigInteger P, BigInteger Q) {
        BigInteger int1 = G.modPow(K, P).mod(Q);
        return int1;
    }

    private BigInteger generateS(BigInteger K, BigInteger H, BigInteger X, BigInteger R, BigInteger Q) {
        BigInteger hPlusXR = H.add(X.multiply(R));
        BigInteger kinv = K.modInverse(Q);
        return kinv.multiply(hPlusXR).mod(Q);
    }

    private BigInteger generateH() {
        return new BigInteger(1, this.dataSeed.digest());
    }

    private SecureRandom getSigningRandom() {
        if (this.signingRandom == null) {
            this.signingRandom = this.appRandom != null ? this.appRandom : new SecureRandom();
        }
        return this.signingRandom;
    }

    private void reset() {
        this.dataSeed.reset();
    }

    private void initialize(DSAParams dsaparams) {
        this.dataSeed.reset();
        this.setParams(dsaparams);
        if (this.certData != null) {
            this.dataSeed.update(this.certData);
        }
    }

    private void setParams(DSAParams dsaParameterSpec) {
        this.presetP = dsaParameterSpec.getP();
        this.presetQ = dsaParameterSpec.getQ();
        this.presetG = dsaParameterSpec.getG();
    }
}

