/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dsa;

import com.initech.provider.crypto.dsa.DSAPrivateKeyImpl;
import com.initech.provider.crypto.dsa.DSAPublicKeyImpl;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPrivateKeySpec) {
                DSAPrivateKeySpec spec = (DSAPrivateKeySpec)keySpec;
                return new DSAPrivateKeyImpl(spec.getX(), spec.getP(), spec.getQ(), spec.getG());
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DSAPrivateKeyImpl(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec spec = (DSAPublicKeySpec)keySpec;
                return new DSAPublicKeyImpl(spec.getY(), spec.getP(), spec.getQ(), spec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DSAPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        try {
            if (key instanceof DSAPublicKeyImpl) {
                Class<?> c1 = Class.forName("com.initech.provider.crypto.spec.DSAPublicKeySpec");
                Class<?> c2 = Class.forName("com.initech.provider.crypto.spec.X509EncodedKeySpec");
                if (c1.isAssignableFrom(keySpec)) {
                    DSAPublicKey pubkey = (DSAPublicKey)key;
                    DSAParams params = pubkey.getParams();
                    return new DSAPublicKeySpec(pubkey.getY(), params.getP(), params.getQ(), params.getG());
                }
                if (c2.isAssignableFrom(keySpec)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof DSAPrivateKeyImpl) {
                Class<?> c1 = Class.forName("com.initech.provider.crypto.spec.DSAPublicKeySpec");
                Class<?> c2 = Class.forName("com.initech.provider.crypto.spec.X509EncodedKeySpec");
                if (c1.isAssignableFrom(keySpec)) {
                    DSAPrivateKey privkey = (DSAPrivateKey)key;
                    DSAParams params = privkey.getParams();
                    return new DSAPrivateKeySpec(privkey.getX(), params.getP(), params.getQ(), params.getG());
                }
                if (c2.isAssignableFrom(keySpec)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof DSAPublicKey) {
                if (key instanceof DSAPublicKeyImpl) {
                    return key;
                }
                DSAPublicKeySpec keySpec = (DSAPublicKeySpec)this.engineGetKeySpec(key, DSAPublicKeySpec.class);
                return this.engineGeneratePublic(keySpec);
            }
            if (key instanceof DSAPrivateKey) {
                if (key instanceof DSAPublicKeyImpl) {
                    return key;
                }
                DSAPrivateKeySpec keySpec = (DSAPrivateKeySpec)this.engineGetKeySpec(key, DSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(keySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }
}

