/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dsa;

import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.dsa.DSAPrivateKeyImpl;
import com.initech.provider.crypto.dsa.DSAPublicKeyImpl;
import com.initech.provider.crypto.md.HAS160;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAKeyPairGenerator
extends KeyPairGenerator {
    int modlen = 1024;
    boolean genParam;
    SecureRandom random = null;
    BigInteger P = null;
    BigInteger Q = null;
    BigInteger G = null;

    public DSAKeyPairGenerator() {
        super("DSA");
    }

    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.P == null || this.Q == null || this.G == null || this.genParam) {
            AlgorithmParameterGenerator apg;
            try {
                apg = AlgorithmParameterGenerator.getInstance("DSA", InitechProvider.NAME);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Initech Provider is not properly intalled");
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException("Initech Provider is not properly intalled");
            }
            apg.init(this.modlen, this.random);
            try {
                DSAParameterSpec spec = apg.generateParameters().getParameterSpec(DSAParameterSpec.class);
                this.P = spec.getP();
                this.Q = spec.getQ();
                this.G = spec.getG();
            }
            catch (InvalidParameterSpecException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        BigInteger X = this.generateX(this.random, this.Q);
        BigInteger Y = this.generateY(this.G, X, this.P, this.Q);
        try {
            DSAPrivateKeyImpl privkey = new DSAPrivateKeyImpl(X, this.P, this.Q, this.G);
            DSAPublicKeyImpl pubkey = new DSAPublicKeyImpl(Y, this.P, this.Q, this.G);
            KeyPair kp = new KeyPair(pubkey, privkey);
            return kp;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private BigInteger generateX(SecureRandom random, BigInteger Q) {
        int[] iv;
        BigInteger X;
        do {
            iv = new int[20];
            for (int i = 0; i < 20; ++i) {
                iv[i] = random.nextInt();
            }
        } while ((X = this.generateX(iv, Q)).signum() <= 0 || X.compareTo(Q) >= 0);
        return X;
    }

    private BigInteger generateX(int[] iv, BigInteger Q) {
        int[] u = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        HAS160.processBlock(u, iv);
        int[] X = u;
        byte[] bytesX = new byte[X.length * 4];
        for (int i = 0; i < X.length; ++i) {
            int j = X[i];
            for (int k = 0; k < 4; ++k) {
                bytesX[i * 4 + k] = (byte)(j >>> 24 - k * 8);
            }
        }
        BigInteger ret = new BigInteger(1, bytesX).mod(Q);
        return ret;
    }

    public BigInteger generateY(BigInteger G, BigInteger X, BigInteger P, BigInteger Q) {
        BigInteger ret = G.modPow(X, P);
        return ret;
    }

    public void initialize(int keysize) {
        this.modlen = keysize;
        this.genParam = true;
        this.random = new SecureRandom();
    }

    public void initialize(int keysize, SecureRandom random) {
        this.modlen = keysize;
        this.genParam = true;
        this.random = random;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.genParam = false;
        DSAParameterSpec spec = (DSAParameterSpec)params;
        this.P = spec.getP();
        this.Q = spec.getQ();
        this.G = spec.getG();
        this.random = random;
    }

    protected void engineZeroize() {
        if (this.P != null) {
            this.P = BigInteger.ZERO;
        }
        if (this.Q != null) {
            this.Q = BigInteger.ZERO;
        }
        if (this.G != null) {
            this.G = BigInteger.ZERO;
        }
        if (this.random != null) {
            this.random = null;
        }
    }
}

