/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dsa;

import com.initech.provider.crypto.InitechProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    static final int plen = 1024;
    static final int qlen = 160;
    static final int probab = 50;
    static final BigInteger ZERO = new BigInteger("0");
    static final BigInteger ONE = new BigInteger("1");
    BigInteger P;
    BigInteger Q;
    BigInteger G;
    DSAParameterSpec spec;
    SecureRandom random;
    int modlen = 1024;
    MessageDigest sha = null;

    private byte[] SHA(byte[] data) {
        if (this.sha == null) {
            try {
                this.sha = MessageDigest.getInstance("SHA1", InitechProvider.NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("SHA1 is not supported");
            }
        }
        this.sha.update(data);
        return this.sha.digest();
    }

    private BigInteger SHA(BigInteger data) {
        return new BigInteger(this.SHA(data.toByteArray()));
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.spec == null) {
            while (!this.generatePandQ()) {
            }
            this.G = this.generateG(this.P, this.Q);
            this.spec = new DSAParameterSpec(this.P, this.Q, this.G);
        }
        try {
            AlgorithmParameters ap = AlgorithmParameters.getInstance("DSA", InitechProvider.NAME);
            ap.init(this.spec);
            return ap;
        }
        catch (Exception e) {
            throw new RuntimeException("DSA algorithm parameter is not supported");
        }
    }

    public boolean generatePandQ() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        BigInteger P = null;
        BigInteger Q = null;
        try {
            BigInteger modulus;
            BigInteger seed;
            int n = (this.modlen - 1) / 160;
            int b = this.modlen - 1 - 160 * n;
            do {
                seed = new BigInteger(160, this.random);
                int seedLength = seed.bitLength();
                modulus = ONE.shiftLeft(seedLength);
                Q = this.SHA(seed).xor(this.SHA(seed.add(ONE).mod(modulus)));
            } while (!(Q = Q.setBit(0).setBit(159)).isProbablePrime(50));
            int N = 2;
            int C = 0;
            int index = this.modlen - 1;
            while (true) {
                BigInteger W = this.SHA(seed.add(BigInteger.valueOf(N)).mod(modulus));
                for (int k = 1; k < n; ++k) {
                    W = W.add(this.SHA(seed.add(BigInteger.valueOf(N + k)).mod(modulus)).shiftLeft(k * 160));
                }
                if (Q.multiply(ONE.shiftLeft(1)).compareTo(ZERO) >= 0) {
                    W = W.add(this.SHA(seed.add(BigInteger.valueOf(N + n)).mod(modulus)).mod(ONE.shiftLeft(b)).shiftLeft(n * 160));
                    P = (W = W.setBit(index)).subtract(W.mod(Q.multiply(ONE.shiftLeft(1)))).add(ONE);
                    if (!P.testBit(index) || !P.isProbablePrime(50)) {
                        ++C;
                        N += n + 1;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Q.multiply(ONE.shiftLeft(1)).compareTo(ZERO) < 0) {
            return false;
        }
        this.P = P;
        this.Q = Q;
        return true;
    }

    private BigInteger generateG(BigInteger P, BigInteger Q) {
        BigInteger A;
        BigInteger G;
        BigInteger E = P.subtract(ONE).divide(Q);
        while ((G = (A = new BigInteger(P.bitLength() - 1, this.random)).modPow(E, P)).compareTo(ONE) != 1) {
        }
        return G;
    }

    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (genParamSpec instanceof DSAParameterSpec) {
            this.spec = (DSAParameterSpec)genParamSpec;
        } else if (genParamSpec instanceof DSAParams) {
            DSAParams param = (DSAParams)((Object)genParamSpec);
            this.spec = new DSAParameterSpec(param.getP(), param.getQ(), param.getG());
        } else {
            throw new InvalidAlgorithmParameterException("inappropriate parameter specification");
        }
        this.random = random;
    }

    protected void engineInit(int size, SecureRandom random) {
        this.modlen = size;
        this.random = random;
    }
}

