/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dsa;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameters
extends AlgorithmParametersSpi {
    protected BigInteger P;
    protected BigInteger Q;
    protected BigInteger G;

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return new DSAParameterData(this.P, this.Q, this.G).getEncoded();
        }
        catch (ASN1Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    protected byte[] engineGetEncoded(String s) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        try {
            Class<?> paramSpec2 = Class.forName("java.security.spec.DSAParameterSpec");
            if (paramSpec2.isAssignableFrom(paramSpec)) {
                return new DSAParameterSpec(this.P, this.Q, this.G);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.P = ((DSAParameterSpec)paramSpec).getP();
        this.Q = ((DSAParameterSpec)paramSpec).getQ();
        this.G = ((DSAParameterSpec)paramSpec).getG();
    }

    protected void engineInit(byte[] params) throws IOException {
        try {
            DSAParameterData paramData = new DSAParameterData(params);
            this.P = paramData.getP();
            this.Q = paramData.getQ();
            this.G = paramData.getG();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected void engineInit(byte[] params, String s) throws IOException {
        this.engineInit(params);
    }

    protected String engineToString() {
        return "\n\tp: " + this.P.toString() + "\n\tq: " + this.Q.toString() + "\n\tg: " + this.G.toString() + "\n";
    }

    public class DSAParameterData
    extends ASN1Object {
        private BigInteger P = null;
        private BigInteger Q = null;
        private BigInteger G = null;

        protected DSAParameterData() {
        }

        protected DSAParameterData(BigInteger P, BigInteger Q, BigInteger G) {
            this.modified = true;
            this.P = P;
            this.Q = Q;
            this.G = G;
        }

        public DSAParameterData(byte[] byteArray) throws ASN1Exception {
            DERDecoder dec = new DERDecoder(byteArray);
            this.decode(dec);
            this.encoded = (byte[])byteArray.clone();
            this.modified = false;
        }

        public void setP(BigInteger P) {
            this.modified = true;
            this.P = P;
        }

        public void setQ(BigInteger Q) {
            this.modified = true;
            this.Q = Q;
        }

        public void setG(BigInteger G) {
            this.modified = true;
            this.G = G;
        }

        public BigInteger getP() {
            return this.P;
        }

        public BigInteger getQ() {
            return this.Q;
        }

        public BigInteger getG() {
            return this.G;
        }

        public void encode(ASN1Encoder enc) throws ASN1Exception {
            int id = enc.encodeSequence();
            enc.encodeInteger(this.P);
            enc.encodeInteger(this.Q);
            enc.encodeInteger(this.G);
            enc.endOf(id);
        }

        public void decode(ASN1Decoder dec) throws ASN1Exception {
            int id = dec.decodeSequence();
            this.P = dec.decodeInteger();
            this.Q = dec.decodeInteger();
            this.G = dec.decodeInteger();
            dec.endOf(id);
        }
    }
}

