/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dsa;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import com.initech.provider.crypto.InitechProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAParameterSpec;

public final class DSAPrivateKeyImpl
implements DSAPrivateKey {
    private static final long serialVersionUID = -7736111816378868191L;
    private BigInteger X;
    private DSAParameterSpec spec;
    private PrivateKeyInfo pkinfo = new PrivateKeyInfo();
    private boolean modified = true;

    public DSAPrivateKeyImpl() {
    }

    public DSAPrivateKeyImpl(BigInteger X, BigInteger P, BigInteger Q, BigInteger G) throws InvalidKeyException {
        this.X = X;
        this.spec = new DSAParameterSpec(P, Q, G);
        this.modified = true;
    }

    public DSAPrivateKeyImpl(byte[] privkey) throws InvalidKeyException {
        try {
            this.pkinfo = new PrivateKeyInfo(privkey);
            if (!this.pkinfo.getAlgorithm().equals("1.2.840.10040.4.1")) {
                throw new InvalidKeyException("this algorithm is not DSA");
            }
            AlgorithmParameters ap = AlgorithmParameters.getInstance("DSA", InitechProvider.NAME);
            ap.init(this.pkinfo.getParameters());
            this.spec = ap.getParameterSpec(DSAParameterSpec.class);
            DERDecoder dec = new DERDecoder(this.pkinfo.getPrivateKey());
            this.X = dec.decodeInteger();
            this.modified = true;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public DSAParams getParams() {
        return this.spec;
    }

    public BigInteger getX() {
        return this.X;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.pkinfo.getEncoded();
            }
            AlgorithmParameters param = AlgorithmParameters.getInstance("DSA", InitechProvider.NAME);
            param.init(this.spec);
            this.pkinfo.setPrivateKeyAlgorithm(new AlgorithmID("1.2.840.10040.4.1", param.getEncoded()));
            DEREncoder enc = new DEREncoder();
            enc.encodeInteger(this.X);
            byte[] key = enc.toByteArray();
            this.pkinfo.setPrivateKey(key);
            byte[] ret = this.pkinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DSAPrivateKey)) {
            return false;
        }
        DSAPrivateKey p = (DSAPrivateKey)o;
        DSAParams pa = p.getParams();
        if (!this.spec.getP().equals(pa.getP())) {
            return false;
        }
        if (!this.spec.getG().equals(pa.getG())) {
            return false;
        }
        if (!this.spec.getQ().equals(pa.getQ())) {
            return false;
        }
        return this.X.equals(p.getX());
    }

    public int hashCode() {
        if (this.X == null) {
            return 0;
        }
        return this.X.hashCode();
    }
}

