/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dsa;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.provider.crypto.InitechProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;

public final class DSAPublicKeyImpl
implements DSAPublicKey {
    private static final long serialVersionUID = -1727659913969529293L;
    private BigInteger Y;
    private DSAParameterSpec spec;
    private PublicKeyInfo kinfo;
    private boolean modified = false;

    public DSAPublicKeyImpl() {
        this.kinfo = new PublicKeyInfo();
    }

    public DSAPublicKeyImpl(BigInteger Y, BigInteger P, BigInteger Q, BigInteger G) throws InvalidKeyException {
        this.Y = Y;
        this.spec = new DSAParameterSpec(P, Q, G);
        this.kinfo = new PublicKeyInfo();
        this.modified = true;
    }

    public DSAPublicKeyImpl(byte[] pubkey) throws InvalidKeyException {
        try {
            this.kinfo = new PublicKeyInfo(pubkey);
            if (!this.kinfo.getAlg().equals("1.2.840.10040.4.1")) {
                throw new InvalidKeyException("this algorithm is not DSA");
            }
            AlgorithmParameters ap = AlgorithmParameters.getInstance("DSA", InitechProvider.NAME);
            ap.init(this.kinfo.getAlgParameter());
            this.spec = ap.getParameterSpec(DSAParameterSpec.class);
            DERDecoder dec = new DERDecoder(this.kinfo.getPublicKeyAsByteArray());
            this.Y = dec.decodeInteger();
            this.modified = true;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public DSAParams getParams() {
        return this.spec;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.kinfo.getEncoded();
            }
            AlgorithmParameters param = AlgorithmParameters.getInstance("DSA", InitechProvider.NAME);
            param.init(this.spec);
            this.kinfo.setAlgName("1.2.840.10040.4.1");
            this.kinfo.setAlgParameter(param.getEncoded());
            DEREncoder enc = new DEREncoder();
            enc.encodeInteger(this.Y);
            byte[] key = enc.toByteArray();
            this.kinfo.setPublicKey(key);
            byte[] ret = this.kinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DSAPublicKey)) {
            return false;
        }
        DSAPublicKey p = (DSAPublicKey)o;
        DSAParams pa = p.getParams();
        if (!this.spec.getP().equals(pa.getP())) {
            return false;
        }
        if (!this.spec.getG().equals(pa.getG())) {
            return false;
        }
        if (!this.spec.getQ().equals(pa.getQ())) {
            return false;
        }
        return this.Y.equals(p.getY());
    }

    public int hashCode() {
        if (this.Y == null) {
            return 0;
        }
        return this.Y.hashCode();
    }
}

