/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.dsa;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import java.math.BigInteger;

public class DSASignedData
extends ASN1Object {
    private static final long serialVersionUID = 4911568788662360466L;
    private BigInteger R = null;
    private BigInteger S = null;

    public DSASignedData() {
    }

    public DSASignedData(BigInteger R, BigInteger S) {
        this.setR(R);
        this.setS(S);
        this.modified = true;
    }

    public DSASignedData(byte[] byteArray) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(byteArray);
        this.decode(dec);
        this.encoded = (byte[])byteArray.clone();
        this.modified = false;
    }

    public void setR(BigInteger R) {
        this.R = R;
    }

    public void setS(BigInteger S) {
        this.S = S;
    }

    public BigInteger getR() {
        return this.R;
    }

    public BigInteger getS() {
        return this.S;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeInteger(this.R);
        enc.encodeInteger(this.S);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.R = dec.decodeInteger();
        this.S = dec.decodeInteger();
        dec.endOf(id);
    }
}

