/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.ecdsa;

import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.ecdsa.ECDSASigValue;
import com.initech.provider.crypto.ecdsa.ECDSA_Fp_PublicKeyImpl;
import com.initech.provider.crypto.ecdsa.ECPoint;
import com.initech.provider.crypto.interfaces.ECDSAParams;
import com.initech.provider.crypto.interfaces.ECDSAPrivateKey;
import com.initech.provider.crypto.interfaces.ECDSAPublicKey;
import com.initech.provider.crypto.spec.ECDSA_Fp_ParameterSpec;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class ECDSA
extends Signature {
    private static BigInteger TWO = BigInteger.valueOf(2L);
    private MessageDigest dataSeed;
    private byte[] mac;
    private PrivateKey privateKey = null;
    private BigInteger presetA;
    private BigInteger presetGx;
    private BigInteger presetGy;
    private BigInteger presetOrder;
    private BigInteger presetPrime;
    private BigInteger presetD;
    private BigInteger presetX;
    private BigInteger presetY;
    private int KByteLen;
    private BigInteger constLimit;
    private SecureRandom signingRandom;
    private SecureRandom appRandom;
    public String hashAlgorithm;
    private byte[] certData;
    private BigInteger presetK = null;
    private BigInteger presetRx = null;
    private BigInteger presetRy = null;

    public ECDSA(String hashAlgorithm) throws NoSuchAlgorithmException {
        super(hashAlgorithm + "withECDSA");
        this.hashAlgorithm = hashAlgorithm;
        try {
            this.dataSeed = MessageDigest.getInstance(hashAlgorithm, InitechProvider.NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(hashAlgorithm + " is not supported");
        }
        this.certData = null;
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ECDSAPrivateKey)) {
            throw new InvalidKeyException("not a ECDSA private key: " + privateKey);
        }
        if (this.privateKey != null && this.privateKey == privateKey) {
            this.reset();
            return;
        }
        ECDSAPrivateKey ecdsaPrivateKey = (ECDSAPrivateKey)privateKey;
        this.presetD = ecdsaPrivateKey.getD();
        this.initialize(ecdsaPrivateKey.getParams());
        this.privateKey = privateKey;
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
        this.appRandom = random;
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECDSAPublicKey)) {
            throw new InvalidKeyException("not a ECDSA public key: " + publicKey);
        }
        ECDSAPublicKey ecdsapublicKey = (ECDSAPublicKey)publicKey;
        this.presetX = ecdsapublicKey.getX();
        this.presetY = ecdsapublicKey.getY();
        this.initialize(ecdsapublicKey.getParams());
    }

    public void engineInitVerify2(ECDSA_Fp_PublicKeyImpl publicKey) throws InvalidKeyException {
        this.presetX = publicKey.getX();
        this.presetY = publicKey.getY();
        this.initialize(publicKey.getParams());
    }

    public void engineSetParameter(String s, Object obj) throws InvalidParameterException {
        throw new InvalidParameterException("this method is depecated.");
    }

    public void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof ECDSAParams)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.setParams((ECDSAParams)((Object)params));
    }

    public Object engineGetParameter(String params) throws InvalidParameterException {
        throw new InvalidParameterException("this method is depecated.");
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public byte[] engineSign() throws SignatureException {
        try {
            BigInteger HM = this.generateHM();
            BigInteger[] KnR = this.generateKnR();
            BigInteger S = this.generateS(KnR[0], KnR[1], HM);
            ECDSASigValue sd = new ECDSASigValue(KnR[1], S);
            return sd.getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    public int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] sbyte;
        BigInteger HM = this.generateHM();
        BigInteger[] KnR = this.generateKnR();
        BigInteger S = this.generateS(KnR[0], KnR[1], HM);
        byte[] rbyte = KnR[1].toByteArray();
        if (rbyte.length + (sbyte = S.toByteArray()).length > outbuf.length - offset) {
            throw new SignatureException("buffer length is too short");
        }
        if (outbuf == null) {
            throw new SignatureException("buffer is null");
        }
        try {
            ECDSASigValue sd = new ECDSASigValue(KnR[1], S);
            byte[] ret = sd.getEncoded();
            System.arraycopy(outbuf, offset, ret, 0, ret.length);
            return ret.length;
        }
        catch (Exception e) {
            throw new SignatureException("error encoding signature");
        }
    }

    public void engineUpdate(byte b) throws SignatureException {
        try {
            this.dataSeed.update(b);
            this.mac = this.dataSeed.digest();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    public void engineUpdate(byte[] b) throws SignatureException {
        try {
            this.dataSeed.update(b);
            this.mac = this.dataSeed.digest();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    public void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        try {
            this.dataSeed.update(b, off, len);
            this.mac = this.dataSeed.digest();
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    public boolean engineVerify(byte[] sigBytes) throws SignatureException {
        ECPoint Q;
        ECPoint u2Q;
        BigInteger RR = null;
        BigInteger SS = null;
        try {
            ECDSASigValue sd = new ECDSASigValue(sigBytes);
            RR = sd.getR();
            SS = sd.getS();
        }
        catch (Exception e) {
            throw new SignatureException("invalid encoding for signature");
        }
        if (RR.compareTo(BigInteger.valueOf(1L)) < 0 || RR.compareTo(this.constLimit) > 0) {
            return false;
        }
        if (SS.compareTo(BigInteger.valueOf(1L)) < 0 || SS.compareTo(this.constLimit) > 0) {
            return false;
        }
        BigInteger HM = this.generateHM();
        BigInteger C = SS.modInverse(this.presetOrder);
        BigInteger u1 = HM.multiply(C).mod(this.presetOrder);
        BigInteger u2 = RR.multiply(C);
        u2 = u2.mod(this.presetOrder);
        ECPoint G = new ECPoint(this.presetGx, this.presetGy);
        ECPoint u1G = G.scalarMultiply(u1, this.presetPrime, this.presetA);
        ECPoint FinalPoint = u1G.add(u2Q = (Q = new ECPoint(this.presetX, this.presetY)).scalarMultiply(u2, this.presetPrime, this.presetA), this.presetPrime, this.presetA);
        if (FinalPoint.equals(ECPoint.INFINITY)) {
            return false;
        }
        BigInteger V = FinalPoint.getX();
        V = V.mod(this.presetOrder);
        return RR.equals(V);
    }

    private BigInteger[] generateKnR() {
        ECPoint p;
        ECPoint r;
        BigInteger R;
        BigInteger K;
        byte[] kByte = new byte[this.KByteLen];
        SecureRandom sr = this.getSigningRandom();
        if (this.presetK == null || this.presetRx == null || this.presetRy == null) {
            do {
                sr.nextBytes(kByte);
            } while ((K = new BigInteger(kByte)).compareTo(this.constLimit) > 0 || K.compareTo(BigInteger.valueOf(1L)) < 0 || (R = (r = (p = new ECPoint(this.presetGx, this.presetGy)).scalarMultiply(K, this.presetPrime, this.presetA)).getX().mod(this.presetOrder)).equals(BigInteger.ZERO));
        } else {
            K = this.presetK.multiply(TWO).mod(this.presetOrder);
            p = new ECPoint(this.presetRx, this.presetRy);
            r = p.add(p, this.presetPrime, this.presetA);
            R = r.getX().mod(this.presetOrder);
            if (R.equals(BigInteger.ZERO)) {
                K = TWO;
                p = new ECPoint(this.presetGx, this.presetGy);
                r = p.add(p, this.presetPrime, this.presetA);
            }
        }
        this.presetK = K;
        this.presetRx = r.getX();
        this.presetRy = r.getY();
        BigInteger[] ret = new BigInteger[]{K, R};
        return ret;
    }

    private BigInteger generateS(BigInteger K, BigInteger R, BigInteger HM) {
        BigInteger Kinv = K.modInverse(this.presetOrder);
        BigInteger S = this.presetD.multiply(R);
        S = S.add(HM);
        S = S.multiply(Kinv);
        S = S.mod(this.presetOrder);
        return S;
    }

    private BigInteger generateHM() {
        return new BigInteger(1, this.mac);
    }

    private SecureRandom getSigningRandom() {
        if (this.signingRandom == null) {
            this.signingRandom = this.appRandom != null ? this.appRandom : new SecureRandom();
        }
        return this.signingRandom;
    }

    private void reset() {
        this.dataSeed.reset();
    }

    private void initialize(ECDSAParams ecdsaparams) {
        this.reset();
        this.setParams(ecdsaparams);
        if (this.certData != null) {
            this.dataSeed.update(this.certData);
        }
    }

    private void setParams(ECDSAParams ecdsaParameterSpec) {
        if (ecdsaParameterSpec == null) {
            return;
        }
        this.presetK = null;
        this.presetRx = null;
        this.presetRy = null;
        this.presetA = ecdsaParameterSpec.getA();
        this.presetGx = ecdsaParameterSpec.getGx();
        this.presetGy = ecdsaParameterSpec.getGy();
        this.presetOrder = ecdsaParameterSpec.getOrder();
        this.constLimit = this.presetOrder.subtract(BigInteger.valueOf(1L));
        this.KByteLen = this.constLimit.toByteArray().length;
        this.presetPrime = ecdsaParameterSpec instanceof ECDSA_Fp_ParameterSpec ? ((ECDSA_Fp_ParameterSpec)ecdsaParameterSpec).getPrime() : null;
    }
}

