/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.ecdsa;

import com.initech.provider.crypto.ecdsa.ECDSA_Fp_PrivateKeyImpl;
import com.initech.provider.crypto.ecdsa.ECDSA_Fp_PublicKeyImpl;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class ECDSAKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new ECDSA_Fp_PrivateKeyImpl(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("only support PKCS8EncodedKeySpec");
        }
        catch (Exception ex) {
            throw new InvalidKeySpecException(ex.toString());
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                return new ECDSA_Fp_PublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("only support X509EncodedKeySpec");
        }
        catch (Exception ex) {
            throw new InvalidKeySpecException(ex.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        throw new UnsupportedOperationException();
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }
}

