/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.ecdsa;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import com.initech.provider.crypto.ecdsa.ECDSA_Fp_PublicKeyImpl;
import com.initech.provider.crypto.ecdsa.ECPoint;
import com.initech.provider.crypto.interfaces.ECDSAParams;
import com.initech.provider.crypto.interfaces.ECDSAPrivateKey;
import com.initech.provider.crypto.spec.ECDSA_Fp_ParameterSpec;
import com.initech.provider.crypto.spec.InitechECDSACurve;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;

public final class ECDSA_Fp_PrivateKeyImpl
implements ECDSAPrivateKey {
    private static final long serialVersionUID = 1L;
    private BigInteger D;
    private ECDSA_Fp_ParameterSpec spec;
    private String curveOID = null;
    private PrivateKeyInfo pkinfo = new PrivateKeyInfo();
    private boolean modified = false;

    public ECDSA_Fp_PrivateKeyImpl() {
    }

    public ECDSA_Fp_PrivateKeyImpl(BigInteger d, String curveName) {
        InitechECDSACurve curve = new InitechECDSACurve(curveName);
        this.spec = curve.make_Fp_ParameterSpec();
        this.curveOID = curve.getOID();
        if (this.spec != null) {
            this.D = d.mod(this.spec.getPrime());
        }
        this.modified = true;
    }

    public ECDSA_Fp_PrivateKeyImpl(BigInteger d, byte[] oid) {
        InitechECDSACurve curve = new InitechECDSACurve(oid);
        this.spec = curve.make_Fp_ParameterSpec();
        this.curveOID = curve.getOID();
        if (this.spec != null) {
            this.D = d.mod(this.spec.getPrime());
        }
        this.modified = true;
    }

    public ECDSA_Fp_PrivateKeyImpl(BigInteger d, BigInteger prime, BigInteger a, BigInteger b, BigInteger gx, BigInteger gy, BigInteger order) throws InvalidKeyException {
        this.spec = new ECDSA_Fp_ParameterSpec(prime, a, b, gx, gy, order);
        this.D = d.mod(this.spec.getPrime());
        this.modified = true;
    }

    public ECDSA_Fp_PrivateKeyImpl(byte[] pvkey) throws InvalidKeyException {
        try {
            byte[] d;
            this.pkinfo = new PrivateKeyInfo(pvkey);
            if (!this.pkinfo.getAlgorithm().equals("1.2.840.10045.2.1")) {
                throw new InvalidKeyException("this algorithm is not ECDSA");
            }
            InitechECDSACurve curve = new InitechECDSACurve(this.pkinfo.getParameters());
            this.spec = curve.make_Fp_ParameterSpec();
            this.curveOID = curve.getOID();
            byte[] ecc_pkey = this.pkinfo.getPrivateKey();
            DERDecoder dec = new DERDecoder(ecc_pkey);
            int id = dec.decodeSequence();
            if (id > 0) {
                dec.decodeInteger();
                d = dec.decodeOctetString();
                if (d == null) {
                    throw new InvalidKeyException("ECDSA private key is null");
                }
            } else {
                throw new InvalidKeyException("this format is not ECDSA");
            }
            this.D = new BigInteger(1, d);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidKeyException(e.toString());
        }
    }

    public void setParam(String curveName) {
        InitechECDSACurve curve = new InitechECDSACurve(curveName);
        this.spec = curve.make_Fp_ParameterSpec();
        this.curveOID = curve.getOID();
        this.modified = true;
    }

    public void setParam(byte[] curveOID) {
        InitechECDSACurve curve = new InitechECDSACurve(curveOID);
        this.spec = curve.make_Fp_ParameterSpec();
        this.curveOID = curve.getOID();
        this.modified = true;
    }

    public void setD(BigInteger d) {
        this.D = d;
        this.modified = true;
    }

    public ECDSAParams getParams() {
        return this.spec;
    }

    public BigInteger getD() {
        return this.D;
    }

    public String getAlgorithm() {
        return "ECDSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public PublicKey getPublic() {
        if (this.spec == null || this.D == null) {
            return null;
        }
        ECPoint G = new ECPoint(this.spec.getGx(), this.spec.getGy());
        ECPoint Q = G.scalarMultiply(this.D, this.spec.getPrime(), this.spec.getA());
        try {
            if (this.curveOID != null) {
                return new ECDSA_Fp_PublicKeyImpl(Q.getX(), Q.getY(), this.curveOID);
            }
            return new ECDSA_Fp_PublicKeyImpl(Q.getX(), Q.getY(), this.spec.getPrime(), this.spec.getA(), this.spec.getB(), this.spec.getGx(), this.spec.getGy(), this.spec.getOrder());
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getEncoded() {
        try {
            DEREncoder enc = new DEREncoder();
            enc.encodeObjectIdentifier(this.curveOID);
            this.pkinfo.setPrivateKeyAlgorithm(new AlgorithmID("1.2.840.10045.2.1", enc.toByteArray()));
            enc = new DEREncoder();
            int seq = enc.encodeSequence();
            enc.encodeInteger(1);
            enc.encodeOctetString(this.D.toByteArray());
            enc.endOf(seq);
            byte[] key = enc.toByteArray();
            this.pkinfo.setPrivateKey(key);
            byte[] ret = this.pkinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

