/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.ecdsa;

import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.provider.crypto.ecdsa.ECPoint;
import com.initech.provider.crypto.interfaces.ECDSAParams;
import com.initech.provider.crypto.interfaces.ECDSAPublicKey;
import com.initech.provider.crypto.spec.ECDSA_Fp_ParameterSpec;
import com.initech.provider.crypto.spec.InitechECDSACurve;
import java.math.BigInteger;
import java.security.InvalidKeyException;

public final class ECDSA_Fp_PublicKeyImpl
implements ECDSAPublicKey {
    private static final long serialVersionUID = -6067595650839061632L;
    private BigInteger X;
    private BigInteger Y;
    private ECDSA_Fp_ParameterSpec spec;
    private PublicKeyInfo kinfo;
    private boolean modified = false;
    private String curveOID = null;

    public ECDSA_Fp_PublicKeyImpl() {
        this.kinfo = new PublicKeyInfo();
    }

    public ECDSA_Fp_PublicKeyImpl(BigInteger x, BigInteger y, BigInteger prime, BigInteger a, BigInteger b, BigInteger gx, BigInteger gy, BigInteger order) throws InvalidKeyException {
        this.kinfo = new PublicKeyInfo();
        this.X = x;
        this.Y = y;
        this.spec = new ECDSA_Fp_ParameterSpec(prime, a, b, gx, gy, order);
        this.modified = true;
    }

    public ECDSA_Fp_PublicKeyImpl(BigInteger x, BigInteger y, String cureveNameOrOID) {
        this.kinfo = new PublicKeyInfo();
        InitechECDSACurve curve = new InitechECDSACurve(cureveNameOrOID);
        this.spec = curve.make_Fp_ParameterSpec();
        this.curveOID = curve.getOID();
        this.X = x;
        this.Y = y;
    }

    public ECDSA_Fp_PublicKeyImpl(byte[] pubkey) throws InvalidKeyException {
        try {
            this.kinfo = new PublicKeyInfo(pubkey);
            if (!this.kinfo.getAlg().equals("1.2.840.10045.2.1")) {
                throw new InvalidKeyException("this algorithm is not ECDSA");
            }
            InitechECDSACurve curve = new InitechECDSACurve(this.kinfo.getAlgParameter());
            this.spec = curve.make_Fp_ParameterSpec();
            this.curveOID = curve.getOID();
            byte[] key = this.kinfo.getPublicKeyAsByteArray();
            ECPoint p = new ECPoint(key, this.spec);
            this.X = p.getX();
            this.Y = p.getY();
            this.modified = false;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public ECDSAParams getParams() {
        return this.spec;
    }

    public BigInteger getX() {
        return this.X;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public String getAlgorithm() {
        return "ECDSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        try {
            DEREncoder enc = new DEREncoder();
            enc.encodeObjectIdentifier(this.curveOID);
            this.kinfo.setAlgName("1.2.840.10045.2.1");
            if (this.curveOID != null) {
                this.kinfo.setAlgParameter(enc.toByteArray());
            } else {
                this.kinfo.setAlgParameter(null);
            }
            ECPoint p = new ECPoint(this.X, this.Y);
            byte[] key = p.toByteArray(this.spec.getPrime());
            this.kinfo.setPublicKey(key);
            byte[] ret = this.kinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

