/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.ecdsa;

import com.initech.provider.crypto.spec.ECDSA_Fp_ParameterSpec;
import java.math.BigInteger;

public class ECPoint {
    private BigInteger X;
    private BigInteger Y;
    private static BigInteger[] posConst = new BigInteger[16];
    public static final ECPoint INFINITY;

    public ECPoint() {
        this.X = new BigInteger("0");
        this.Y = new BigInteger("0");
    }

    public ECPoint(BigInteger x, BigInteger y) {
        this.X = new BigInteger(x.toByteArray());
        this.Y = new BigInteger(y.toByteArray());
    }

    public ECPoint(byte[] arr) {
        int l = arr.length - 1;
        if (arr[0] != 2 && arr[0] != 3) {
            byte[] t = new byte[l /= 2];
            System.arraycopy(arr, 1, t, 0, l);
            this.X = new BigInteger(1, t);
            System.arraycopy(arr, 1 + l, t, 0, l);
            this.Y = new BigInteger(1, t);
        }
    }

    public ECPoint(byte[] arr, ECDSA_Fp_ParameterSpec param) {
        int l = arr.length - 1;
        if (arr[0] == 2 || arr[0] == 3) {
            byte[] t = new byte[arr.length - 1];
            System.arraycopy(arr, 1, t, 0, t.length);
            this.X = new BigInteger(1, t);
            BigInteger p = param.getPrime();
            BigInteger a = param.getA();
            BigInteger b = param.getB();
            BigInteger tmp = this.X.pow(3).add(a.multiply(this.X)).add(b).mod(p);
            BigInteger z = this.sqrtPrime(tmp, p);
            this.Y = z.mod(BigInteger.valueOf(2L)).intValue() == arr[0] - 2 ? z : p.subtract(z);
        } else {
            byte[] t = new byte[l /= 2];
            System.arraycopy(arr, 1, t, 0, l);
            this.X = new BigInteger(1, t);
            System.arraycopy(arr, 1 + l, t, 0, l);
            this.Y = new BigInteger(1, t);
        }
    }

    private BigInteger sqrtPrime(BigInteger x, BigInteger p) {
        if (p.testBit(1)) {
            return x.modPow(p.shiftRight(2).add(BigInteger.ONE), p);
        }
        if (p.testBit(2)) {
            BigInteger twog = x.shiftLeft(1).mod(p);
            BigInteger gamma = twog.modPow(p.shiftRight(3), p);
            BigInteger i = twog.multiply(gamma).multiply(gamma).mod(p);
            return x.multiply(gamma).multiply(i.subtract(BigInteger.ONE)).mod(p);
        }
        BigInteger k = p.add(BigInteger.ONE).shiftRight(1);
        BigInteger P = BigInteger.ONE;
        BigInteger[] VQ0;
        BigInteger halfV;
        BigInteger z;
        while ((z = (halfV = ((VQ0 = this.lucas(P, x, k, p))[0].testBit(0) ? VQ0[0].add(p) : VQ0[0]).shiftRight(1)).mod(p)).pow(2).compareTo(x) != 0) {
            if (VQ0[1].compareTo(BigInteger.ONE) > 0 && VQ0[1].compareTo(p.subtract(BigInteger.ONE)) < 0) {
                return null;
            }
            P = P.add(BigInteger.ONE);
        }
        return z;
    }

    private BigInteger[] lucas(BigInteger P, BigInteger Q, BigInteger k, BigInteger p) {
        BigInteger v_0 = new BigInteger("2");
        BigInteger v_1 = P;
        BigInteger q_0 = BigInteger.ONE;
        BigInteger q_1 = BigInteger.ONE;
        for (int i = k.bitLength() - 1; i >= 0; --i) {
            q_0 = q_0.multiply(q_1).mod(p);
            if (k.testBit(i)) {
                q_1 = q_0.multiply(Q).mod(p);
                v_0 = v_0.multiply(v_1).subtract(P.multiply(q_0)).mod(p);
                v_1 = v_1.multiply(v_1).subtract(q_1.shiftLeft(1)).mod(p);
                continue;
            }
            q_1 = q_0;
            v_1 = v_0.multiply(v_1).subtract(P.multiply(q_0)).mod(p);
            v_0 = v_0.multiply(v_0).subtract(q_0.shiftLeft(1)).mod(p);
        }
        return new BigInteger[]{v_0, q_0};
    }

    public void setX(BigInteger x) {
        this.X = new BigInteger(x.toByteArray());
    }

    public void setY(BigInteger y) {
        this.Y = new BigInteger(y.toByteArray());
    }

    public BigInteger getX() {
        return this.X;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public void negate(BigInteger prime) {
        this.Y = this.Y.negate();
        this.Y = this.Y.mod(prime);
    }

    public void negate() {
        this.Y = this.Y.negate();
    }

    public boolean equals(Object o) {
        if (o instanceof ECPoint) {
            ECPoint p = (ECPoint)o;
            if (!this.X.equals(p.getX())) {
                return false;
            }
            return this.Y.equals(p.getY());
        }
        return false;
    }

    public ECPoint subtract(ECPoint p, BigInteger prime, BigInteger a) {
        ECPoint t = new ECPoint(p.getX(), p.getY());
        t.negate(prime);
        return this.add(t, prime, a);
    }

    public ECPoint add(ECPoint p, BigInteger prime, BigInteger a) {
        BigInteger l;
        BigInteger x1 = this.X;
        BigInteger y1 = this.Y;
        BigInteger x2 = p.getX();
        BigInteger y2 = p.getY();
        if (this.equals(INFINITY)) {
            return new ECPoint(x2, y2);
        }
        if (p.equals(INFINITY)) {
            return new ECPoint(x1, y1);
        }
        if (!x1.equals(x2) && !y1.equals(y2)) {
            BigInteger t1 = y2.subtract(y1);
            BigInteger t2 = x2.subtract(x1).modInverse(prime);
            l = t1.multiply(t2);
            l = l.mod(prime);
        } else {
            if (!this.Y.equals(y1)) {
                return new ECPoint();
            }
            if (y1.equals(posConst[0])) {
                return new ECPoint();
            }
            BigInteger t1 = x1.multiply(x1);
            t1 = t1.multiply(posConst[3]);
            t1 = t1.add(a);
            BigInteger t2 = y1.multiply(posConst[2]);
            t2 = t2.modInverse(prime);
            l = t1.multiply(t2);
            l = l.mod(prime);
        }
        BigInteger x3 = l.pow(2).subtract(x1).subtract(x2).mod(prime);
        BigInteger t3 = x1.subtract(x3);
        BigInteger y3 = l.multiply(t3).subtract(y1).mod(prime);
        return new ECPoint(x3, y3);
    }

    public ECPoint newscalarMultiply(BigInteger n, BigInteger prime, BigInteger a, BigInteger order) {
        int i;
        BigInteger k = null;
        int d = 0;
        if (n.equals(posConst[0])) {
            return new ECPoint();
        }
        k = n.compareTo(posConst[0]) < 0 ? n.negate() : n;
        d = order.bitLength() / 4;
        if (order.bitLength() % 4 > 0) {
            ++d;
        }
        ECPoint[] pts = new ECPoint[5];
        ECPoint[] vec = new ECPoint[16];
        pts[0] = new ECPoint();
        pts[1] = new ECPoint(this.X, this.Y);
        for (i = 0; i < d; ++i) {
            pts[1] = pts[1].add(pts[1], prime, a);
        }
        pts[2] = pts[1];
        for (i = 0; i < d; ++i) {
            pts[2] = pts[2].add(pts[2], prime, a);
        }
        pts[3] = pts[2];
        for (i = 0; i < d; ++i) {
            pts[3] = pts[3].add(pts[3], prime, a);
        }
        pts[4] = pts[3];
        for (i = 0; i < d; ++i) {
            pts[4] = pts[4].add(pts[4], prime, a);
        }
        vec[0] = pts[0];
        vec[1] = pts[1];
        vec[2] = pts[2];
        vec[3] = pts[1].add(pts[2], prime, a);
        vec[4] = pts[3];
        vec[5] = vec[4].add(vec[1], prime, a);
        vec[6] = vec[4].add(vec[2], prime, a);
        vec[7] = vec[4].add(vec[3], prime, a);
        vec[8] = pts[4];
        vec[9] = vec[8].add(vec[1], prime, a);
        vec[10] = vec[8].add(vec[2], prime, a);
        vec[11] = vec[8].add(vec[3], prime, a);
        vec[12] = vec[8].add(vec[4], prime, a);
        vec[13] = vec[8].add(vec[5], prime, a);
        vec[14] = vec[8].add(vec[6], prime, a);
        vec[15] = vec[8].add(vec[7], prime, a);
        ECPoint S = new ECPoint();
        for (i = d - 1; i >= 0; --i) {
            int A = 0;
            for (int j = 3; j >= 0; --j) {
                A *= 2;
                A += k.testBit(i + j * d) ? 1 : 0;
            }
            S = S.add(S, prime, a);
            S = S.add(vec[A], prime, a);
        }
        if (k.compareTo(posConst[0]) < 0) {
            S.negate(prime);
        }
        return S;
    }

    public ECPoint scalarMultiply(BigInteger n, BigInteger prime, BigInteger a) {
        BigInteger k;
        ECPoint Q;
        if (n.equals(posConst[0])) {
            return new ECPoint();
        }
        if (n.compareTo(posConst[0]) < 0) {
            Q = new ECPoint(this.X, this.Y);
            k = n.negate().mod(prime);
        } else {
            Q = new ECPoint(this.X, this.Y);
            k = new BigInteger(n.toByteArray());
        }
        BigInteger h = k.multiply(posConst[3]);
        ECPoint nQ = new ECPoint(Q.getX(), Q.getY());
        nQ.negate(prime);
        ECPoint S = new ECPoint(Q.getX(), Q.getY());
        for (int i = h.bitLength() - 2; i >= 1; --i) {
            S = S.add(S, prime, a);
            boolean hOn = h.testBit(i);
            boolean kOn = k.testBit(i);
            if (hOn && !kOn) {
                S = S.add(Q, prime, a);
                continue;
            }
            if (hOn || !kOn) continue;
            S = S.add(nQ, prime, a);
        }
        return S;
    }

    public ECPoint pdouble(ECPoint p, BigInteger prime, BigInteger a) {
        BigInteger T4;
        BigInteger T5;
        BigInteger X1 = p.getX();
        BigInteger Y1 = p.getY();
        BigInteger T1 = X1;
        BigInteger T2 = Y1;
        BigInteger T3 = posConst[1];
        if (a.equals(prime.subtract(posConst[3]))) {
            T5 = X1.subtract(posConst[1]);
            T4 = X1.add(posConst[1]);
            T5 = T4.multiply(T5);
            T4 = T5.multiply(posConst[3]);
        } else {
            T4 = X1.modPow(posConst[2], prime);
            T4 = T4.multiply(posConst[3]);
            T4 = T4.add(a);
        }
        T3 = Y1.multiply(posConst[2]);
        T2 = Y1.modPow(posConst[2], prime);
        T5 = X1.multiply(T2);
        T5 = T5.multiply(posConst[4]);
        T1 = T4.modPow(posConst[2], prime);
        BigInteger T6 = T5.multiply(posConst[2]);
        T1 = T1.subtract(T6);
        T2 = T2.modPow(posConst[2], prime);
        T2 = T2.multiply(posConst[8]);
        T5 = T5.subtract(T1);
        T5 = T4.multiply(T5);
        T2 = T5.subtract(T2);
        T5 = T3.modPow(posConst[2], prime);
        T6 = T5.multiply(T3);
        T5 = T5.modInverse(prime);
        T6 = T6.modInverse(prime);
        BigInteger X2 = T1.multiply(T5);
        X2 = X2.mod(prime);
        BigInteger Y2 = T2.multiply(T6);
        Y2 = Y2.mod(prime);
        return new ECPoint(X2, Y2);
    }

    public ECPoint padd(ECPoint p, BigInteger prime, BigInteger a) {
        BigInteger T1 = new BigInteger(this.X.toByteArray());
        BigInteger T2 = new BigInteger(this.Y.toByteArray());
        BigInteger T4 = this.X.subtract(p.getX());
        BigInteger T5 = this.Y.subtract(p.getY());
        if (T4.equals(posConst[0])) {
            // empty if block
        }
        T1 = this.X.multiply(posConst[2]);
        T1 = T1.subtract(T4);
        T2 = this.Y.multiply(posConst[2]);
        T2 = T2.subtract(T5);
        BigInteger T3 = new BigInteger(T4.toByteArray());
        BigInteger T7 = T4.modPow(posConst[2], prime);
        T4 = T4.multiply(T7);
        T7 = T1.multiply(T7);
        T1 = T5.modPow(posConst[2], prime);
        T1 = T1.subtract(T7);
        BigInteger T6 = T1.multiply(posConst[2]);
        T7 = T7.subtract(T6);
        T5 = T5.multiply(T7);
        T4 = T2.multiply(T4);
        T2 = T5.subtract(T4);
        T6 = posConst[2].modInverse(prime);
        T2 = T2.multiply(T6);
        T5 = T3.modPow(posConst[2], prime);
        T6 = T5.multiply(T3);
        T5 = T5.modInverse(prime);
        T6 = T6.modInverse(prime);
        BigInteger X2 = T1.multiply(T5);
        X2 = X2.mod(prime);
        BigInteger Y2 = T2.multiply(T6);
        Y2 = Y2.mod(prime);
        return new ECPoint(X2, Y2);
    }

    public String toString() {
        return "[X=" + this.X.toString(10) + "; Y=" + this.Y.toString(10) + "]";
    }

    public byte[] toByteArray(BigInteger prime) {
        int i;
        byte[] b = this.bigNumToByteArray(prime);
        byte[] ret = new byte[1 + b.length * 2];
        ret[0] = 4;
        byte[] x = this.bigNumToByteArray(this.X);
        byte[] y = this.bigNumToByteArray(this.Y);
        for (i = 1; i < b.length - x.length; ++i) {
            ret[i] = 0;
        }
        System.arraycopy(x, 0, ret, i, x.length);
        for (i = 1 + b.length; i < 1 + 2 * b.length - y.length; ++i) {
            ret[i] = 0;
        }
        System.arraycopy(y, 0, ret, i, y.length);
        return ret;
    }

    private byte[] bigNumToByteArray(BigInteger p) {
        if (p == null) {
            return null;
        }
        byte[] b = p.toByteArray();
        if (b[0] != 0) {
            return b;
        }
        byte[] c = new byte[b.length - 1];
        System.arraycopy(b, 1, c, 0, c.length);
        return c;
    }

    static {
        for (long i = 0L; i < 16L; ++i) {
            ECPoint.posConst[(int)i] = BigInteger.valueOf(i);
        }
        INFINITY = new ECPoint(posConst[0], posConst[0]);
    }
}

