/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.entropy;

import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA384;
import com.initech.provider.crypto.md.SHA512;
import com.initech.provider.crypto.random.HashDRBG;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.StringTokenizer;

public class AixEntropy {
    private static transient MessageDigest md;
    static String cmdTop;

    public AixEntropy(String hashAlg) {
        if (hashAlg.equalsIgnoreCase("SHA1")) {
            md = new SHA1();
        }
        if (hashAlg.equalsIgnoreCase("SHA224")) {
            md = new SHA224();
        }
        if (hashAlg.equalsIgnoreCase("SHA256")) {
            md = new SHA256();
        }
        if (hashAlg.equalsIgnoreCase("SHA384")) {
            md = new SHA384();
        }
        if (hashAlg.equalsIgnoreCase("SHA512")) {
            md = new SHA512();
        }
    }

    ByteBuffer fastMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        ByteBuffer generatedShaNonceEntropy = ByteBuffer.allocate(outputEntropyShaNonceLen);
        try {
            int nonceLen = outputEntropyShaNonceLen - hashLen;
            Object entropyDataStr = null;
            byte[] nonceEntropyByte = this.systemRandomGen(100);
            generatedShaNonceEntropy.put(md.digest(nonceEntropyByte));
            generatedShaNonceEntropy.rewind();
            if (noncePluseFlag == 1) {
                generatedShaNonceEntropy.get(nonceEntropyByte, 0, hashLen);
                for (int i = 0; i < nonceLen; ++i) {
                    int n = i;
                    nonceEntropyByte[n] = (byte)(nonceEntropyByte[n] ^ nonceEntropyByte[i + nonceLen]);
                }
                generatedShaNonceEntropy.put(nonceEntropyByte, hashLen, nonceLen);
            }
        }
        catch (Exception e) {
            byte[] nonceEntropyByte = this.systemRandomGen(outputEntropyShaNonceLen);
            generatedShaNonceEntropy.put(nonceEntropyByte);
        }
        return (ByteBuffer)generatedShaNonceEntropy.rewind();
    }

    ByteBuffer normalMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        return this.fastMode(noncePluseFlag, outputEntropyShaNonceLen, hashLen);
    }

    ByteBuffer slowMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        ByteBuffer generatedShaNonceEntropy = ByteBuffer.allocate(outputEntropyShaNonceLen);
        try {
            int i;
            int nonceLen = outputEntropyShaNonceLen - hashLen;
            String entropyDataStr = null;
            byte[] nonceEntropyByte = this.systemRandomGen(100);
            entropyDataStr = new String(this.getCurrentJVMPid(this.getCurrentJVMPid()));
            entropyDataStr = entropyDataStr + new String(this.memoryEntropy());
            entropyDataStr = entropyDataStr + new String(this.systemPropertyEntropy());
            entropyDataStr = entropyDataStr + new String(this.systemTimeMillisEntropy());
            entropyDataStr = entropyDataStr + new String(this.systemRandomGen(100));
            generatedShaNonceEntropy.put(md.digest(entropyDataStr.getBytes()));
            generatedShaNonceEntropy.rewind();
            byte[] t_0x00 = new byte[entropyDataStr.getBytes().length];
            for (i = 0; i < t_0x00.length; ++i) {
                t_0x00[i] = 0;
            }
            entropyDataStr = new String(t_0x00);
            entropyDataStr = null;
            if (noncePluseFlag == 1) {
                generatedShaNonceEntropy.get(nonceEntropyByte, 0, hashLen);
                for (i = 0; i < nonceLen; ++i) {
                    int n = i;
                    nonceEntropyByte[n] = (byte)(nonceEntropyByte[n] ^ nonceEntropyByte[i + nonceLen]);
                }
                generatedShaNonceEntropy.put(nonceEntropyByte, hashLen, nonceLen);
            }
        }
        catch (Exception e) {
            byte[] nonceEntropyByte = this.systemRandomGen(outputEntropyShaNonceLen);
            generatedShaNonceEntropy.put(nonceEntropyByte);
        }
        return (ByteBuffer)generatedShaNonceEntropy.rewind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] systemRandomGen(int len) {
        byte[] systemRAND = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/dev/urandom");
            systemRAND = new byte[len];
            int readCount = 0;
            while ((readCount = fis.read(systemRAND)) != -1 && readCount <= 1) {
            }
        }
        catch (FileNotFoundException ffe) {
            try {
                HashDRBG random = new HashDRBG("SHA224");
                random.nextBytes(systemRAND);
            }
            catch (Exception e) {
                throw new RuntimeException("can not used SystemRandom for Entropy");
            }
        }
        catch (IOException ioe) {
            try {
                HashDRBG random = new HashDRBG("SHA224");
                random.nextBytes(systemRAND);
            }
            catch (Exception e) {
                throw new RuntimeException("can not used SystemRandom for Entropy");
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemRAND;
    }

    byte[] pidInfo() throws IOException {
        byte[] bytePid = new byte[100];
        String[] cmd = new String[]{"bash", "-c", "ps -ef|grep find"};
        Process p = Runtime.getRuntime().exec(cmd);
        p.getInputStream().read(bytePid);
        return bytePid;
    }

    byte[] getCurrentJVMPid(int pid) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.putInt(pid);
        buff.order(ByteOrder.BIG_ENDIAN);
        return buff.array();
    }

    int getCurrentJVMPid() {
        SecureRandom r = new SecureRandom();
        int pid = r.nextInt() & Integer.MAX_VALUE;
        String cmd = "/bin/sh -c @$PPID@";
        try {
            Process myProcess = Runtime.getRuntime().exec(cmd);
            InputStream is = myProcess.getErrorStream();
            BufferedReader stdout = new BufferedReader(new InputStreamReader(is));
            String line = stdout.readLine();
            StringTokenizer st = new StringTokenizer(line, "@");
            if (st.hasMoreTokens()) {
                st.nextToken();
                int ppid = Integer.parseInt(st.nextToken());
                if (ppid > 0) {
                    pid = ppid;
                }
            }
        }
        catch (Exception e) {
            pid = 0;
        }
        return pid;
    }

    byte[] memoryEntropy() {
        return Hex.longToByteArray(Runtime.getRuntime().freeMemory());
    }

    byte[] systemTimeMillisEntropy() {
        long systemMillis = System.currentTimeMillis();
        byte[] systemMillis2Byte = Hex.longToByteArray(systemMillis);
        return systemMillis2Byte;
    }

    byte[] systemPropertyEntropy() {
        String systemPropertyUserName = new String(System.getProperty("user.name"));
        String systemPropertyUserDir = new String(System.getProperty("user.dir"));
        String systemPropertyUserHome = new String(System.getProperty("user.home"));
        String systemPropertyLibPath = new String(System.getProperty("java.library.path"));
        String systemPropertyOSArch = new String(System.getProperty("os.arch"));
        String systemPropertyVMSpecVer = new String(System.getProperty("java.vm.specification.version"));
        String systemPropertyVMname = new String(System.getProperty("java.vm.name"));
        String sysProperty = systemPropertyUserName + systemPropertyUserDir + systemPropertyUserHome + systemPropertyLibPath + systemPropertyOSArch + systemPropertyVMSpecVer + systemPropertyVMname;
        return sysProperty.getBytes();
    }

    void networkIpTcpUdpEntropy() throws SocketException, IOException {
        int c;
        Process process = Runtime.getRuntime().exec("bash -c netstat -n");
        InputStream standardOutput = process.getInputStream();
        InputStream standardError = process.getErrorStream();
        String output = "";
        while ((c = standardOutput.read()) != -1) {
            output = output + new Character((char)c).toString();
        }
        while ((c = standardError.read()) != -1) {
            standardOutput.close();
        }
        standardError.close();
        BufferedReader br = new BufferedReader(new StringReader(output));
        System.out.println("MAC Address Test0");
        String line = null;
        while ((line = br.readLine()) != null) {
            if (!line.trim().startsWith("Physical Address")) continue;
            String mac = line.substring(line.indexOf(":") + 1, line.length()).trim();
            System.out.println("MAC Address : " + mac);
        }
    }

    byte[] getCpu() {
        double cpu = -1.0;
        try {
            String line;
            String cmd = cmdTop;
            Process child = Runtime.getRuntime().exec(cmd);
            InputStream lsOut = child.getInputStream();
            InputStreamReader r = new InputStreamReader(lsOut);
            BufferedReader in = new BufferedReader(r);
            int emptyLines = 0;
            while (emptyLines < 3) {
                line = in.readLine();
                if (line.length() >= 1) continue;
                ++emptyLines;
            }
            in.readLine();
            in.readLine();
            line = in.readLine();
            System.out.println("Parsing line " + line);
            String delims = "%";
            String[] parts = line.split(delims);
            System.out.println("Parsing fragment " + parts[0]);
            delims = " ";
            parts = parts[0].split(delims);
            cpu = Double.parseDouble(parts[parts.length - 1]);
        }
        catch (Exception e) {
            System.out.println("Command failed!");
        }
        byte[] cpuByte = Hex.longToByteArray((long)cpu);
        System.out.println("CPU Info :" + Hex.byteArrayToHex(cpuByte));
        return cpuByte;
    }

    public void test() {
        Thread th = null;
        for (int i = 0; i < 10; ++i) {
            th = new Thread(new TR(i));
            System.out.println("MyThread-" + (1000 + i));
            th.start();
        }
        if (th != null) {
            th.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] currentProcessStatInfo() throws IOException, FileNotFoundException {
        int pidInfo = this.getCurrentJVMPid();
        String pidStr = Integer.toString(pidInfo);
        String line = null;
        byte[] pidState = null;
        System.out.println("Current Process ID Info = " + pidStr);
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader("/proc/" + pidStr + "/stat");
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                System.out.println("Current Process Stat Info = " + line);
                pidState = line.getBytes();
            }
        }
        finally {
            if (br != null && fr != null) {
                try {
                    br.close();
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return pidState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] currentProcessStatusInfo() throws IOException, FileNotFoundException {
        int pidInfo = this.getCurrentJVMPid();
        String pidStr = Integer.toString(pidInfo);
        InputStreamReader fr = null;
        BufferedReader br = null;
        byte[] pidState = null;
        String line = null;
        try {
            fr = new FileReader("/proc/" + pidStr + "/status");
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                System.out.println("Current Process Status Info = " + line);
            }
            pidState = line.getBytes();
        }
        finally {
            if (br != null && fr != null) {
                try {
                    br.close();
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return pidState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] wtmpLogInfo(int len) throws IOException, FileNotFoundException {
        SecureRandom rand = new SecureRandom();
        File fi = new File("/var/adm/wtmp");
        byte[] systemLog = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/var/adm/wtmp");
            int fileSize = 0;
            int skipPosition = 0;
            fileSize = (int)fi.length();
            System.out.println("file Size : " + fileSize);
            skipPosition = rand.nextInt(fileSize -= len);
            System.out.println("skipPosition : " + skipPosition);
            fis.skip(fileSize);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
            System.out.println("Wtmp Log[Hex]-[readPosition : " + skipPosition + "] : " + Hex.byteArrayToHex(systemLog));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sysMailLogInfo(int len) throws IOException, FileNotFoundException {
        SecureRandom rand = new SecureRandom();
        File fi = new File("/var/adm/syslog/mail.log");
        byte[] systemLog = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/var/adm/syslog/mail.log");
            int fileSize = 0;
            int skipPosition = 0;
            fileSize = (int)fi.length();
            System.out.println("file Size : " + fileSize);
            skipPosition = rand.nextInt(fileSize -= len);
            System.out.println("skipPosition : " + skipPosition);
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
            System.out.println("System Mail Log[Hex]-[readPosition : " + skipPosition + "] : " + Hex.byteArrayToHex(systemLog));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] ptyDaemonLogInfo(int len) throws IOException, FileNotFoundException {
        SecureRandom rand = new SecureRandom();
        File fi = new File("/var/adm/ptydaemonlog");
        byte[] systemLog = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/var/adm/ptydaemonlog");
            int fileSize = 0;
            int skipPosition = 0;
            fileSize = (int)fi.length();
            System.out.println("file Size : " + fileSize);
            skipPosition = rand.nextInt(fileSize -= len);
            System.out.println("skipPosition : " + skipPosition);
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
            System.out.println("System ptyDaemon Log[Hex]-[readPosition : " + skipPosition + "] : " + Hex.byteArrayToHex(systemLog));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] diskInfo(int len) throws IOException, FileNotFoundException {
        SecureRandom rand = new SecureRandom();
        File fi = new File("/etc/diskinfo");
        byte[] systemLog = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/etc/diskinfo");
            int fileSize = 0;
            int skipPosition = 0;
            boolean readCount = false;
            fileSize = (int)fi.length();
            System.out.println("file Size : " + fileSize);
            System.out.println("File Size : " + (fileSize -= len));
            skipPosition = rand.nextInt(fileSize);
            System.out.println("skipPosition : " + skipPosition);
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
            System.out.println("System Disk Info Log[Hex]-[readPosition : " + skipPosition + "] : " + Hex.byteArrayToHex(systemLog));
            System.out.println("File Size : " + fileSize);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] shutdownLogInfo(int len) throws IOException, FileNotFoundException {
        SecureRandom rand = new SecureRandom();
        File fi = new File("/etc/shutdownlog");
        byte[] systemLog = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/etc/shutdownlog");
            int fileSize = 0;
            int skipPosition = 0;
            boolean readCount = false;
            fileSize = (int)fi.length();
            System.out.println("file Size : " + fileSize);
            System.out.println("File Size : " + (fileSize -= len));
            skipPosition = rand.nextInt(fileSize);
            System.out.println("skipPosition : " + skipPosition);
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
            System.out.println("System Shutdown Log[Hex]-[readPosition : " + skipPosition + "] : " + Hex.byteArrayToHex(systemLog));
            System.out.println("File Size : " + fileSize);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemLog;
    }

    static {
        cmdTop = "top -n 2 -b -d 0.2";
    }

    public class TR
    implements Runnable {
        int ins = 0;

        TR(int i) {
            this.ins = i;
        }

        public void run() {
            while (true) {
                if (this.ins == 5) {
                    continue;
                }
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

