/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.entropy;

import com.initech.provider.crypto.entropy.Entropy;
import com.initech.provider.crypto.entropy.VMEntropy;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA384;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class EntropyAdapter
implements Entropy {
    private VMEntropy entropy = null;

    public EntropyAdapter() {
        this.loadEntropyClass();
    }

    private void loadEntropyClass() {
        String className = "";
        className = this.getVmVersion() < 1.5 || this.getComplierVersion() < 49 ? "com.initech.provider.crypto.entropy.VMEntropy14" : "com.initech.provider.crypto.entropy.VMEntropy15";
        try {
            Class<?> entropy_class = Class.forName(className);
            this.entropy = (VMEntropy)entropy_class.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
    }

    private double getVmVersion() {
        double ret;
        String version = System.getProperty("java.version");
        int pos = version.indexOf(46);
        pos = version.indexOf(46, pos + 1);
        try {
            ret = Double.parseDouble(version.substring(0, pos));
        }
        catch (Exception e) {
            return 1.0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getComplierVersion() {
        int major = 0;
        int minor = 0;
        FilterInputStream dis = null;
        try {
            InputStream class_is = this.getClass().getResourceAsStream("EntropyAdapter.class");
            dis = new DataInputStream(class_is);
            int magic = ((DataInputStream)dis).readInt();
            if (magic != -889275714) {
                System.out.println("this class is not a java class!");
            } else {
                minor = ((DataInputStream)dis).readUnsignedShort();
                major = ((DataInputStream)dis).readUnsignedShort();
            }
        }
        catch (IOException e) {
            System.out.println(major + "." + minor);
            int n = 1;
            return n;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    return 1;
                }
            }
        }
        return major;
    }

    public byte[] collection(String hashAlgrithm) {
        MessageDigest md = this.getMessageDigest(hashAlgrithm);
        byte[] seed = md.digest(this.collection());
        return seed;
    }

    private byte[] collection() {
        byte[] entropy1 = this.entropy.getSystementropy();
        byte[] entropy2 = this.entropy.getSystementropy();
        byte[] entropy_data = new byte[128];
        System.arraycopy(entropy1, 0, entropy_data, 0, entropy1.length);
        System.arraycopy(entropy2, 0, entropy_data, entropy1.length, entropy2.length);
        return entropy_data;
    }

    private MessageDigest getMessageDigest(String hashAlgrithm) {
        com.initech.cryptox.MessageDigest md = null;
        if (hashAlgrithm.equalsIgnoreCase("SHA1")) {
            md = new SHA1();
        }
        if (hashAlgrithm.equalsIgnoreCase("SHA224")) {
            md = new SHA224();
        }
        if (hashAlgrithm.equalsIgnoreCase("SHA256")) {
            md = new SHA256();
        }
        if (hashAlgrithm.equalsIgnoreCase("SHA384")) {
            md = new SHA384();
        }
        if (hashAlgrithm.equalsIgnoreCase("SHA512")) {
            md = new SHA384();
        }
        return md;
    }
}

