/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.entropy;

import com.initech.provider.crypto.SelfTest;
import com.initech.provider.crypto.entropy.AixEntropy;
import com.initech.provider.crypto.entropy.HpEntropy;
import com.initech.provider.crypto.entropy.LinuxEntropy;
import com.initech.provider.crypto.entropy.SolarisEntropy;
import com.initech.provider.crypto.entropy.WindowsEntropy;
import java.nio.ByteBuffer;

public class EntropyB {
    private static final String WIN_OSNAME = "Windows";
    private static final String LINUX_OSNAME = "Linux";
    private static final String SOLARIA_OSNAME = "SunOS";
    private static final String HP_OSNAME = "HP-UX";
    private static final String AIX_OSNAME = "AIX";
    private static final int FAST_MODE = 0;
    private static final int NORMAL_MODE = 1;
    private static final int SLOW_MODE = 2;
    private static String REALTIME_OS = System.getProperty("os.name");
    ByteBuffer generatedEntropy = null;
    WindowsEntropy we = null;
    LinuxEntropy le = null;
    SolarisEntropy se = null;
    HpEntropy he = null;
    AixEntropy ae = null;

    public ByteBuffer entropyCollectionOfOS(int entropyOutputLen, int collectionEntropyMode, int securityStrength, int maxEntropyLen, String hashAlg, int noncePluseFlag) {
        if (SelfTest.getState() == 3) {
            collectionEntropyMode = 2;
        } else if (collectionEntropyMode != 0 && collectionEntropyMode != 1 && collectionEntropyMode != 2) {
            collectionEntropyMode = 0;
        }
        try {
            int hashLen = 0;
            int mdOutputEntropyNonceLen = 0;
            if (entropyOutputLen > maxEntropyLen) {
                System.out.println("Input Error of Request Output Entropy Length");
            }
            if (hashAlg.equals("SHA1") || hashAlg.equals("SHA-1")) {
                hashLen = 20;
            }
            if (hashAlg.equals("SHA224") || hashAlg.equals("SHA-224")) {
                hashLen = 28;
            }
            if (hashAlg.equals("SHA256") || hashAlg.equals("SHA-256")) {
                hashLen = 32;
            }
            if (hashAlg.equals("SHA384") || hashAlg.equals("SHA-384")) {
                hashLen = 48;
            }
            if (hashAlg.equals("SHA512") || hashAlg.equals("SHA-512")) {
                hashLen = 64;
            }
            mdOutputEntropyNonceLen = noncePluseFlag == 1 ? entropyOutputLen + entropyOutputLen / 2 : entropyOutputLen;
            this.generatedEntropy = ByteBuffer.allocate(mdOutputEntropyNonceLen);
            this.generatedEntropy.rewind();
            if (REALTIME_OS.startsWith(WIN_OSNAME)) {
                this.we = new WindowsEntropy(hashAlg);
                switch (collectionEntropyMode) {
                    case 0: {
                        this.generatedEntropy.put(this.we.fastMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 1: {
                        this.generatedEntropy.put(this.we.normalMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 2: {
                        this.generatedEntropy.put(this.we.slowMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    default: {
                        System.out.println("[" + collectionEntropyMode + "]Illegal Mode Opeation " + REALTIME_OS);
                    }
                }
            }
            if (REALTIME_OS.startsWith(LINUX_OSNAME)) {
                this.le = new LinuxEntropy(hashAlg);
                switch (collectionEntropyMode) {
                    case 0: {
                        this.generatedEntropy.put(this.le.fastMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 1: {
                        this.generatedEntropy.put(this.le.normalMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 2: {
                        this.generatedEntropy.put(this.le.slowMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    default: {
                        System.out.println("[" + collectionEntropyMode + "]Illegal Mode Opeation " + REALTIME_OS);
                    }
                }
            }
            if (REALTIME_OS.startsWith(SOLARIA_OSNAME)) {
                this.se = new SolarisEntropy(hashAlg);
                switch (collectionEntropyMode) {
                    case 0: {
                        this.generatedEntropy.put(this.se.fastMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 1: {
                        this.generatedEntropy.put(this.se.normalMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 2: {
                        this.generatedEntropy.put(this.se.slowMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    default: {
                        System.out.println("[" + collectionEntropyMode + "]Illegal Mode Opeation " + REALTIME_OS);
                    }
                }
            }
            if (REALTIME_OS.startsWith(HP_OSNAME)) {
                this.he = new HpEntropy(hashAlg);
                switch (collectionEntropyMode) {
                    case 0: {
                        this.generatedEntropy.put(this.he.fastMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 1: {
                        this.generatedEntropy.put(this.he.normalMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 2: {
                        this.generatedEntropy.put(this.he.slowMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    default: {
                        System.out.println("[" + collectionEntropyMode + "]Illegal Mode Opeation " + REALTIME_OS);
                    }
                }
            }
            if (REALTIME_OS.startsWith(AIX_OSNAME)) {
                this.ae = new AixEntropy(hashAlg);
                switch (collectionEntropyMode) {
                    case 0: {
                        this.generatedEntropy.put(this.ae.fastMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 1: {
                        this.generatedEntropy.put(this.ae.normalMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    case 2: {
                        this.generatedEntropy.put(this.ae.slowMode(noncePluseFlag, mdOutputEntropyNonceLen, hashLen));
                        break;
                    }
                    default: {
                        System.out.println("[" + collectionEntropyMode + "]Illegal Mode Opeation " + REALTIME_OS);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.generatedEntropy.rewind();
        return this.generatedEntropy;
    }

    public final void zeroize() {
        if (this.generatedEntropy != null) {
            this.generatedEntropy = ByteBuffer.allocate(0);
        }
    }
}

