/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.entropy;

import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA384;
import com.initech.provider.crypto.md.SHA512;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.StringTokenizer;

public class SolarisEntropy {
    private static transient MessageDigest md;
    static String cmdTop;

    public SolarisEntropy(String hashAlg) {
        if (hashAlg.equalsIgnoreCase("SHA1")) {
            md = new SHA1();
        }
        if (hashAlg.equalsIgnoreCase("SHA224")) {
            md = new SHA224();
        }
        if (hashAlg.equalsIgnoreCase("SHA256")) {
            md = new SHA256();
        }
        if (hashAlg.equalsIgnoreCase("SHA384")) {
            md = new SHA384();
        }
        if (hashAlg.equalsIgnoreCase("SHA512")) {
            md = new SHA512();
        }
    }

    ByteBuffer fastMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        ByteBuffer generatedShaNonceEntropy = ByteBuffer.allocate(outputEntropyShaNonceLen);
        try {
            int nonceLen = outputEntropyShaNonceLen - hashLen;
            Object entropyDataStr = null;
            byte[] nonceEntropyByte = this.systemRandomGen(100);
            generatedShaNonceEntropy.put(md.digest(nonceEntropyByte));
            generatedShaNonceEntropy.rewind();
            if (noncePluseFlag == 1) {
                generatedShaNonceEntropy.get(nonceEntropyByte, 0, hashLen);
                for (int i = 0; i < nonceLen; ++i) {
                    int n = i;
                    nonceEntropyByte[n] = (byte)(nonceEntropyByte[n] ^ nonceEntropyByte[i + nonceLen]);
                }
                generatedShaNonceEntropy.put(nonceEntropyByte, hashLen, nonceLen);
            }
        }
        catch (Exception e) {
            byte[] nonceEntropyByte = this.systemRandomGen(outputEntropyShaNonceLen);
            generatedShaNonceEntropy.put(nonceEntropyByte);
        }
        return (ByteBuffer)generatedShaNonceEntropy.rewind();
    }

    ByteBuffer normalMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        return this.fastMode(noncePluseFlag, outputEntropyShaNonceLen, hashLen);
    }

    ByteBuffer slowMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        ByteBuffer generatedShaNonceEntropy = ByteBuffer.allocate(outputEntropyShaNonceLen);
        try {
            int i;
            int nonceLen = outputEntropyShaNonceLen - hashLen;
            String entropyDataStr = null;
            byte[] nonceEntropyByte = this.systemRandomGen(100);
            entropyDataStr = new String(this.getCurrentJVMPid(this.getCurrentJVMPid()));
            entropyDataStr = entropyDataStr + new String(this.memoryEntropy());
            entropyDataStr = entropyDataStr + new String(this.systemPropertyEntropy());
            entropyDataStr = entropyDataStr + new String(this.systemTimeMillisEntropy());
            entropyDataStr = entropyDataStr + new String(this.systemRandomGen(100));
            generatedShaNonceEntropy.put(md.digest(entropyDataStr.getBytes()));
            generatedShaNonceEntropy.rewind();
            byte[] t_0x00 = new byte[entropyDataStr.getBytes().length];
            for (i = 0; i < t_0x00.length; ++i) {
                t_0x00[i] = 0;
            }
            entropyDataStr = new String(t_0x00);
            entropyDataStr = null;
            if (noncePluseFlag == 1) {
                generatedShaNonceEntropy.get(nonceEntropyByte, 0, hashLen);
                for (i = 0; i < nonceLen; ++i) {
                    int n = i;
                    nonceEntropyByte[n] = (byte)(nonceEntropyByte[n] ^ nonceEntropyByte[i + nonceLen]);
                }
                generatedShaNonceEntropy.put(nonceEntropyByte, hashLen, nonceLen);
            }
        }
        catch (Exception e) {
            byte[] nonceEntropyByte = this.systemRandomGen(outputEntropyShaNonceLen);
            generatedShaNonceEntropy.put(nonceEntropyByte);
        }
        return (ByteBuffer)generatedShaNonceEntropy.rewind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] systemRandomGen(int len) {
        SecureRandom rand = null;
        byte[] systemRAND = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/dev/random");
            systemRAND = new byte[len];
            int readCount = 0;
            while ((readCount = fis.read(systemRAND)) != -1 && readCount <= 1) {
            }
        }
        catch (FileNotFoundException ffe) {
            rand = new SecureRandom();
            rand.nextBytes(systemRAND);
        }
        catch (IOException ioe) {
            rand = new SecureRandom();
            rand.nextBytes(systemRAND);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemRAND;
    }

    byte[] pidInfo() throws IOException {
        byte[] bytePid = new byte[100];
        String[] cmd = new String[]{"bash", "-c", "ps -ef|grep find"};
        Process p = Runtime.getRuntime().exec(cmd);
        p.getInputStream().read(bytePid);
        return bytePid;
    }

    byte[] getCurrentJVMPid(int pid) {
        ByteBuffer buff = ByteBuffer.allocate(5);
        buff.putInt(pid);
        buff.order(ByteOrder.BIG_ENDIAN);
        return buff.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentJVMPid() {
        SecureRandom r = new SecureRandom();
        int pid = r.nextInt() & Integer.MAX_VALUE;
        String cmd = "/bin/sh -c @$PPID@";
        InputStream is = null;
        BufferedReader stdout = null;
        try {
            Process myProcess = Runtime.getRuntime().exec(cmd);
            is = myProcess.getErrorStream();
            stdout = new BufferedReader(new InputStreamReader(is));
            String line = stdout.readLine();
            StringTokenizer st = new StringTokenizer(line, "@");
            if (st.hasMoreTokens()) {
                st.nextToken();
                int ppid = Integer.parseInt(st.nextToken());
                if (ppid > 0) {
                    pid = ppid;
                }
            }
        }
        catch (Exception e) {
            pid = 0;
        }
        finally {
            if (is != null && stdout != null) {
                try {
                    is.close();
                    stdout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return pid;
    }

    byte[] memoryEntropy() {
        return Hex.longToByteArray(Runtime.getRuntime().freeMemory());
    }

    byte[] systemTimeMillisEntropy() {
        long systemMillis = System.currentTimeMillis();
        byte[] systemMillis2Byte = Hex.longToByteArray(systemMillis);
        return systemMillis2Byte;
    }

    byte[] systemPropertyEntropy() {
        String systemPropertyUserName = new String(System.getProperty("user.name"));
        String systemPropertyUserDir = new String(System.getProperty("user.dir"));
        String systemPropertyUserHome = new String(System.getProperty("user.home"));
        String systemPropertyLibPath = new String(System.getProperty("java.library.path"));
        String systemPropertyOSArch = new String(System.getProperty("os.arch"));
        String systemPropertyVMSpecVer = new String(System.getProperty("java.vm.specification.version"));
        String systemPropertyVMname = new String(System.getProperty("java.vm.name"));
        String sysProperty = systemPropertyUserName + systemPropertyUserDir + systemPropertyUserHome + systemPropertyLibPath + systemPropertyOSArch + systemPropertyVMSpecVer + systemPropertyVMname;
        return sysProperty.getBytes();
    }

    byte[] getCpu() {
        double cpu = -1.0;
        try {
            String line;
            String cmd = cmdTop;
            Process child = Runtime.getRuntime().exec(cmd);
            InputStream lsOut = child.getInputStream();
            InputStreamReader r = new InputStreamReader(lsOut);
            BufferedReader in = new BufferedReader(r);
            int emptyLines = 0;
            while (emptyLines < 3) {
                line = in.readLine();
                if (line.length() >= 1) continue;
                ++emptyLines;
            }
            in.readLine();
            in.readLine();
            line = in.readLine();
            String delims = "%";
            String[] parts = line.split(delims);
            delims = " ";
            parts = parts[0].split(delims);
            cpu = Double.parseDouble(parts[parts.length - 1]);
        }
        catch (Exception e) {
            System.out.println("Command failed!");
        }
        byte[] cpuByte = Hex.longToByteArray((long)cpu);
        return cpuByte;
    }

    void test() {
        Thread th = null;
        for (int i = 0; i < 10; ++i) {
            th = new Thread(new TR(i));
            System.out.println("MyThread-" + (1000 + i));
            th.start();
        }
        if (th != null) {
            th.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] currentProcessStatInfo() throws IOException, FileNotFoundException {
        int pidInfo = this.getCurrentJVMPid();
        String pidStr = Integer.toString(pidInfo);
        InputStreamReader fr = null;
        BufferedReader br = null;
        String line = null;
        byte[] pidState = null;
        try {
            fr = new FileReader("/proc/" + pidStr + "/stat");
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                pidState = line.getBytes();
            }
        }
        finally {
            if (fr != null && br != null) {
                fr.close();
                br.close();
            }
        }
        return pidState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] currentProcessStatusInfo() throws IOException, FileNotFoundException {
        int pidInfo = this.getCurrentJVMPid();
        String pidStr = Integer.toString(pidInfo);
        String line = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        byte[] pidState = null;
        try {
            fr = new FileReader("/proc/" + pidStr + "/status");
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
            }
            pidState = line.getBytes();
        }
        finally {
            if (br != null && fr != null) {
                br.close();
                fr.close();
            }
        }
        return pidState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] systemLogInfo(int len) throws IOException, FileNotFoundException {
        FileInputStream fis = null;
        File fi = null;
        byte[] systemLog = new byte[len];
        try {
            fis = new FileInputStream("/var/log/syslog");
            fi = new File("/var/log/syslog");
            boolean readCountK = false;
            int readCount = 0;
            int stopCount = 0;
            long fileUnitLen = 0L;
            long systemMillis = 0L;
            fileUnitLen = fi.length() / (long)len;
            systemMillis = System.currentTimeMillis();
            stopCount = (int)(fileUnitLen - systemMillis % fileUnitLen);
            while (fis.read(systemLog) != -1) {
                System.out.println("System Log[Hex]-[readCount : " + readCount + "] : " + Hex.byteArrayToHex(systemLog));
                if (++readCount <= stopCount) continue;
                break;
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return systemLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sysLogInfo(int len) throws IOException, FileNotFoundException {
        SecureRandom rand = new SecureRandom();
        File fi = new File("/var/log/syslog");
        byte[] systemLog = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/var/log/syslog");
            int fileSize = 0;
            int skipPosition = 0;
            fileSize = (int)fi.length();
            skipPosition = rand.nextInt(fileSize -= len);
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return systemLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sysLastLogInfo(int len) throws IOException, FileNotFoundException {
        SecureRandom rand = new SecureRandom();
        File fi = new File("/var/adm/lastlog");
        byte[] systemLog = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/var/adm/lastlog");
            int fileSize = 0;
            int skipPosition = 0;
            boolean readCount = false;
            fileSize = (int)fi.length();
            System.out.println("file Size : " + fileSize);
            skipPosition = (fileSize -= len) + rand.nextInt(fileSize);
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return systemLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sysMessageLogInfo(int len) throws IOException, FileNotFoundException {
        SecureRandom rand = new SecureRandom();
        File fi = new File("/var/adm/messages");
        byte[] systemLog = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/var/adm/messages");
            int fileSize = 0;
            int skipPosition = 0;
            boolean readCount = false;
            fileSize = (int)fi.length();
            System.out.println("file Size : " + fileSize);
            skipPosition = rand.nextInt(fileSize -= len);
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return systemLog;
    }

    static {
        cmdTop = "top -n 2 -b -d 0.2";
    }

    public class TR
    implements Runnable {
        int ins = 0;

        TR(int i) {
            this.ins = i;
        }

        public void run() {
            while (true) {
                if (this.ins == 5) {
                    continue;
                }
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

