/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.entropy;

import com.initech.provider.crypto.entropy.VMEntropy;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VMEntropy15
implements VMEntropy {
    public byte[] getSystementropy() {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        ArrayList<Long> value_list = new ArrayList<Long>();
        value_list.add(this.getSystemTime1());
        value_list.add(this.getRunTime1());
        value_list.add(this.getThreadTime());
        value_list.add(this.getMemoryUsed());
        value_list.add(this.getGCCount());
        value_list.add(this.getRunTime2());
        value_list.add(this.getSystemTime2());
        Collections.shuffle(value_list);
        for (int i = 0; i < value_list.size(); ++i) {
            buffer.putLong((Long)value_list.get(i));
        }
        return buffer.array();
    }

    private Long getSystemTime1() {
        return new Long(System.nanoTime());
    }

    private Long getSystemTime2() {
        return new Long(System.currentTimeMillis());
    }

    private Long getGCCount() {
        long count = 0L;
        List<GarbageCollectorMXBean> gc_beans = ManagementFactory.getGarbageCollectorMXBeans();
        for (int i = 0; i < gc_beans.size(); ++i) {
            GarbageCollectorMXBean gc_bean = gc_beans.get(i);
            count += gc_bean.getCollectionTime();
            count += gc_bean.getCollectionCount();
        }
        return new Long(count);
    }

    private Long getThreadTime() {
        ThreadMXBean thd_bean = ManagementFactory.getThreadMXBean();
        return new Long(thd_bean.getCurrentThreadUserTime());
    }

    private Long getMemoryUsed() {
        int used_time = 0;
        List<MemoryPoolMXBean> mem_p_beans = ManagementFactory.getMemoryPoolMXBeans();
        for (int i = 0; i < mem_p_beans.size(); ++i) {
            MemoryPoolMXBean mem_p_bean = mem_p_beans.get(i);
            used_time = (int)((long)used_time + mem_p_bean.getUsage().getUsed());
        }
        return new Long(used_time);
    }

    private Long getRunTime1() {
        RuntimeMXBean run_bean = ManagementFactory.getRuntimeMXBean();
        return new Long(run_bean.getUptime());
    }

    private Long getRunTime2() {
        RuntimeMXBean run_bean = ManagementFactory.getRuntimeMXBean();
        return new Long(run_bean.getStartTime() - run_bean.getUptime());
    }
}

