/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.entropy;

import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA384;
import com.initech.provider.crypto.md.SHA512;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class WindowsEntropy {
    private static transient MessageDigest md;

    public WindowsEntropy(String hashAlg) {
        if (hashAlg.equalsIgnoreCase("SHA1")) {
            md = new SHA1();
        }
        if (hashAlg.equalsIgnoreCase("SHA224")) {
            md = new SHA224();
        }
        if (hashAlg.equalsIgnoreCase("SHA256")) {
            md = new SHA256();
        }
        if (hashAlg.equalsIgnoreCase("SHA384")) {
            md = new SHA384();
        }
        if (hashAlg.equalsIgnoreCase("SHA512")) {
            md = new SHA512();
        }
    }

    ByteBuffer fastMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        ByteBuffer generatedShaNonceEntropy = ByteBuffer.allocate(outputEntropyShaNonceLen);
        try {
            int nonceLen = outputEntropyShaNonceLen - hashLen;
            Object entropyDataStr = null;
            byte[] nonceEntropyByte = this.systemRandomGen(100);
            generatedShaNonceEntropy.put(md.digest(nonceEntropyByte));
            generatedShaNonceEntropy.rewind();
            if (noncePluseFlag == 1) {
                generatedShaNonceEntropy.get(nonceEntropyByte, 0, hashLen);
                for (int i = 0; i < nonceLen; ++i) {
                    int n = i;
                    nonceEntropyByte[n] = (byte)(nonceEntropyByte[n] ^ nonceEntropyByte[i + nonceLen]);
                }
                generatedShaNonceEntropy.put(nonceEntropyByte, hashLen, nonceLen);
                generatedShaNonceEntropy.rewind();
            }
        }
        catch (Exception e) {
            byte[] nonceEntropyByte = this.systemRandomGen(outputEntropyShaNonceLen);
            generatedShaNonceEntropy.put(nonceEntropyByte);
        }
        return generatedShaNonceEntropy;
    }

    ByteBuffer normalMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        return this.fastMode(noncePluseFlag, outputEntropyShaNonceLen, hashLen);
    }

    ByteBuffer slowMode(int noncePluseFlag, int outputEntropyShaNonceLen, int hashLen) {
        ByteBuffer generatedShaNonceEntropy = ByteBuffer.allocate(outputEntropyShaNonceLen);
        try {
            int i;
            int nonceLen = outputEntropyShaNonceLen - hashLen;
            String entropyDataStr = null;
            byte[] nonceEntropyByte = this.systemRandomGen(100);
            entropyDataStr = entropyDataStr + new String(this.systemTimeMillisEntropy());
            entropyDataStr = entropyDataStr + new String(this.memoryEntropy());
            entropyDataStr = entropyDataStr + new String(this.systemRandomGen(100));
            entropyDataStr = entropyDataStr + new String(this.windowsUpdateLogInfo(32));
            entropyDataStr = entropyDataStr + new String(this.windowsCBSLogInfo(32));
            entropyDataStr = entropyDataStr + new String(this.windowsDPXLogInfo(32));
            generatedShaNonceEntropy.put(md.digest(entropyDataStr.getBytes()));
            generatedShaNonceEntropy.rewind();
            byte[] t_0x00 = new byte[entropyDataStr.getBytes().length];
            for (i = 0; i < t_0x00.length; ++i) {
                t_0x00[i] = 0;
            }
            entropyDataStr = new String(t_0x00);
            entropyDataStr = null;
            if (noncePluseFlag == 1) {
                generatedShaNonceEntropy.get(nonceEntropyByte, 0, hashLen);
                for (i = 0; i < nonceLen; ++i) {
                    int n = i;
                    nonceEntropyByte[n] = (byte)(nonceEntropyByte[n] ^ nonceEntropyByte[i + nonceLen]);
                }
                generatedShaNonceEntropy.put(nonceEntropyByte, hashLen, nonceLen);
                generatedShaNonceEntropy.rewind();
            }
        }
        catch (Exception e) {
            byte[] nonceEntropyByte = this.systemRandomGen(outputEntropyShaNonceLen);
            generatedShaNonceEntropy.put(nonceEntropyByte);
        }
        return generatedShaNonceEntropy;
    }

    private byte[] systemRandomGen(int len) {
        Random rand = null;
        byte[] randBytes = new byte[len];
        try {
            SecureRandom systemRAND = SecureRandom.getInstance("SHA1PRNG", InitechProvider.NAME);
            systemRAND.nextBytes(randBytes);
        }
        catch (NoSuchAlgorithmException nsae) {
        }
        catch (Exception e) {
            rand = new Random();
            rand.nextBytes(randBytes);
        }
        return randBytes;
    }

    private byte[] memoryEntropy() {
        return Hex.longToByteArray(Runtime.getRuntime().freeMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] windowsUpdateLogInfo(int len) {
        byte[] systemLog;
        FileInputStream fis = null;
        try {
            Random rand = new Random();
            File fi = new File("C:/Windows/WindowsUpdate.log");
            systemLog = new byte[len];
            fis = new FileInputStream("C:/Windows/WindowsUpdate.log");
            int fileSize = 0;
            int skipPosition = 0;
            fileSize = (int)fi.length();
            skipPosition = fileSize -= len;
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
        }
        catch (Exception e) {
            systemLog = this.systemRandomGen(32);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] windowsCBSLogInfo(int len) {
        byte[] systemLog;
        FileInputStream fis = null;
        try {
            Random rand = new Random();
            File fi = new File("C:/Windows/Logs/CBS/CBS.log");
            systemLog = new byte[len];
            fis = new FileInputStream("C:/Windows/Logs/CBS/CBS.log");
            int fileSize = 0;
            int skipPosition = 0;
            fileSize = (int)fi.length();
            skipPosition = fileSize -= len;
            fis.skip(fileSize);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
            fis.close();
        }
        catch (Exception e) {
            systemLog = this.systemRandomGen(32);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemLog;
    }

    private byte[] systemTimeMillisEntropy() {
        long systemMillis = System.currentTimeMillis();
        byte[] systemMillis2Byte = Hex.longToByteArray(systemMillis);
        return systemMillis2Byte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] windowsDPXLogInfo(int len) {
        byte[] systemLog;
        FileInputStream fis = null;
        try {
            Random rand = new Random();
            File fi = new File("C:/Windows/Logs/DPX/setupact.log");
            systemLog = new byte[len];
            fis = new FileInputStream("C:/Windows/Logs/DPX/setupact.log");
            int fileSize = 0;
            int skipPosition = 0;
            fileSize = (int)fi.length();
            skipPosition = fileSize -= len;
            fis.skip(skipPosition);
            if (fis.read(systemLog) != -1) {
                // empty if block
            }
        }
        catch (Exception e) {
            systemLog = this.systemRandomGen(32);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return systemLog;
    }
}

