/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.cryptox.Signature;
import com.initech.provider.crypto.interfaces.KCDSAParams;
import com.initech.provider.crypto.interfaces.KCDSAPrivateKey;
import com.initech.provider.crypto.interfaces.KCDSAPublicKey;
import com.initech.provider.crypto.kcdsa.KCDSASignedData;
import com.initech.provider.crypto.md.HAS160;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA224;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.md.SHA384;
import com.initech.provider.crypto.md.SHA512;
import java.math.BigInteger;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class KCDSA
extends Signature {
    private MessageDigest dataSeed;
    private MessageDigest TMP_md;
    private KCDSAParams params;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    private BigInteger presetX;
    private BigInteger presetY;
    private byte[] H;
    private byte[] E_byte;
    private byte[] R;
    private byte[] Z;
    private int digestLen;
    private SecureRandom signingRandom;
    private SecureRandom appRandom;
    protected String hashAlgorithm;
    static final BigInteger ZERO = BigInteger.valueOf(0L);

    public KCDSA(String hashAlgorithm) throws NoSuchAlgorithmException {
        super(hashAlgorithm + "withKCDSA");
        this.hashAlgorithm = hashAlgorithm;
        try {
            if (hashAlgorithm.equalsIgnoreCase("SHA1")) {
                this.dataSeed = new SHA1();
                this.TMP_md = new SHA1();
            } else if (hashAlgorithm.equalsIgnoreCase("HAS160")) {
                this.dataSeed = new HAS160();
                this.TMP_md = new HAS160();
            } else if (hashAlgorithm.equalsIgnoreCase("SHA224")) {
                this.dataSeed = new SHA224();
                this.TMP_md = new SHA224();
            } else if (hashAlgorithm.equalsIgnoreCase("SHA256")) {
                this.dataSeed = new SHA256();
                this.TMP_md = new SHA256();
            } else if (hashAlgorithm.equalsIgnoreCase("SHA384")) {
                this.dataSeed = new SHA384();
                this.TMP_md = new SHA384();
            } else if (hashAlgorithm.equalsIgnoreCase("SHA512")) {
                this.dataSeed = new SHA512();
                this.TMP_md = new SHA512();
            }
            this.digestLen = this.dataSeed.getDigestLength();
        }
        catch (Exception e) {
            throw new RuntimeException(hashAlgorithm + " is not supported");
        }
    }

    protected void _engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof KCDSAPrivateKey)) {
            throw new InvalidKeyException("not a KCDSA private key: " + privateKey);
        }
        KCDSAPrivateKey kcdsaPrivateKey = (KCDSAPrivateKey)privateKey;
        this.presetX = kcdsaPrivateKey.getX();
        this.presetY = kcdsaPrivateKey.getY();
        this.initialize(kcdsaPrivateKey.getParams());
    }

    protected void _engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof KCDSAPrivateKey)) {
            throw new InvalidKeyException("not a KCDSA private key: " + privateKey);
        }
        KCDSAPrivateKey kcdsaPrivateKey = (KCDSAPrivateKey)privateKey;
        this.presetX = kcdsaPrivateKey.getX();
        this.presetY = kcdsaPrivateKey.getY();
        this.appRandom = random;
        this.initialize(kcdsaPrivateKey.getParams());
    }

    protected void _engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey.getAlgorithm().equals("KCDSA") || publicKey.getAlgorithm().equals("kcdsa")) {
            KCDSAPublicKey kcdsaPublicKey = (KCDSAPublicKey)publicKey;
            this.presetY = kcdsaPublicKey.getY();
            this.initialize(kcdsaPublicKey.getParams());
            return;
        }
        throw new InvalidKeyException("not a KCDSA public key: " + publicKey);
    }

    protected void _engineSetParameter(String s, Object obj) throws InvalidParameterException {
        throw new InvalidParameterException("this method is depecated.");
    }

    protected void _engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof KCDSAParams)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.setParams((KCDSAParams)((Object)params));
    }

    protected Object _engineGetParameter(String params) throws InvalidParameterException {
        throw new InvalidParameterException("this method is depecated.");
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected byte[] _engineSign() throws SignatureException {
        byte[] sig = null;
        try {
            BigInteger E;
            BigInteger K;
            BigInteger S;
            this.generateH();
            do {
                K = this.generateK();
                this.generateR(K);
            } while ((S = this.generateS(K, E = this.generateE())).compareTo(ZERO) == 0);
            KCDSASignedData sd = new KCDSASignedData(this.R, S);
            sig = sd.getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage());
        }
        this.reset();
        return sig;
    }

    protected int _engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] sig = null;
        try {
            BigInteger E;
            BigInteger K;
            BigInteger S;
            this.generateH();
            do {
                K = this.generateK();
                this.generateR(K);
            } while ((S = this.generateS(K, E = this.generateE())).compareTo(ZERO) == 0);
            KCDSASignedData sd = new KCDSASignedData(this.R, S);
            sig = sd.getEncoded();
            if (sig.length > outbuf.length - offset) {
                throw new SignatureException("Too Short Buffer");
            }
            System.arraycopy(sig, 0, outbuf, offset, sig.length);
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage());
        }
        this.reset();
        return sig.length;
    }

    protected void _engineUpdate(byte b) throws SignatureException {
        try {
            this.dataSeed.update(b);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected void _engineUpdate(byte[] b, int off, int len) throws SignatureException {
        try {
            this.dataSeed.update(b, off, len);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    protected boolean _engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] RR = null;
        BigInteger SS = null;
        try {
            KCDSASignedData sd = new KCDSASignedData(sigBytes);
            RR = sd.getR();
            SS = sd.getS();
            if (RR.length != this.digestLen) {
                throw new SignatureException("Invalid R length");
            }
            if (SS.compareTo(this.presetQ) >= 0 || SS.compareTo(ZERO) <= 0) {
                throw new SignatureException("Invalid S");
            }
            System.arraycopy(RR, 0, this.R, 0, this.digestLen);
            this.generateH();
            BigInteger EE = this.generateE();
            BigInteger WW = this.generateWW(SS, EE);
            this.reset();
            return this.isEqual(WW);
        }
        catch (Exception e) {
            throw new SignatureException("invalid encoding for signature");
        }
    }

    private boolean isEqual(BigInteger W) {
        byte[] w = W.toByteArray();
        if (w[0] == 0 && (w[1] & 0xFFFFFF80) != 0) {
            byte[] w2 = new byte[w.length - 1];
            System.arraycopy(w, 1, w2, 0, w2.length);
            w = w2;
        }
        int p_len = this.presetP.bitLength() / 8;
        int w_len = w.length;
        this.TMP_md.update(w);
        byte[] r = this.TMP_md.digest();
        return Arrays.equals(r, this.R);
    }

    private BigInteger generateK() {
        BigInteger K;
        byte[] r = new byte[this.presetQ.bitLength() / 8];
        SecureRandom sr = this.getSigningRandom();
        do {
            this.signingRandom.nextBytes(r);
        } while ((K = new BigInteger(1, r)).compareTo(this.presetQ) != -1);
        return K;
    }

    private BigInteger generateWW(BigInteger S, BigInteger E) {
        BigInteger YS = this.presetY.modPow(S, this.presetP);
        BigInteger GE = this.presetG.modPow(E, this.presetP);
        BigInteger YSGE = YS.multiply(GE);
        return YSGE.mod(this.presetP);
    }

    private void generateR(BigInteger K) throws DigestException {
        BigInteger W = this.presetG.modPow(K, this.presetP);
        byte[] w = W.toByteArray();
        if (w[0] == 0 && (w[1] & 0xFFFFFF80) != 0) {
            byte[] w2 = new byte[w.length - 1];
            System.arraycopy(w, 1, w2, 0, w2.length);
            w = w2;
        }
        int p_len = this.presetP.bitLength() / 8;
        int w_len = w.length;
        this.TMP_md.update(w);
        this.TMP_md.digest(this.R, 0, this.digestLen);
    }

    private void generateH() throws DigestException {
        this.dataSeed.digest(this.H, 0, this.digestLen);
    }

    private BigInteger generateE() {
        for (int i = 0; i < this.digestLen; ++i) {
            this.E_byte[i] = (byte)(this.R[i] ^ this.H[i]);
        }
        BigInteger t = new BigInteger(1, this.E_byte);
        return t.mod(this.presetQ);
    }

    private BigInteger generateS(BigInteger K, BigInteger E) {
        BigInteger KE = K.subtract(E);
        BigInteger XKE = this.presetX.multiply(KE);
        return XKE.mod(this.presetQ);
    }

    private SecureRandom getSigningRandom() {
        if (this.signingRandom == null) {
            this.signingRandom = this.appRandom != null ? this.appRandom : new SecureRandom();
        }
        return this.signingRandom;
    }

    private void initialize(KCDSAParams kcdsaparams) {
        this.H = new byte[this.digestLen];
        this.E_byte = new byte[this.digestLen];
        this.R = new byte[this.digestLen];
        this.Z = new byte[64];
        byte[] t = this.presetY.toByteArray();
        int tIdx = t.length > 64 ? t.length - 64 : 0;
        int zIdx = t.length > 64 ? 0 : 64 - t.length;
        int zLen = t.length > 64 ? 64 : t.length;
        System.arraycopy(t, tIdx, this.Z, zIdx, zLen);
        this.dataSeed.reset();
        this.dataSeed.update(this.Z);
        this.setParams(kcdsaparams);
    }

    private void reset() {
        this.dataSeed.reset();
        this.dataSeed.update(this.Z);
    }

    private void setParams(KCDSAParams kcdsaParameterSpec) {
        this.presetP = kcdsaParameterSpec.getP();
        this.presetQ = kcdsaParameterSpec.getQ();
        this.presetG = kcdsaParameterSpec.getG();
    }
}

