/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.cryptox.KeyFactorySpi;
import com.initech.provider.crypto.interfaces.KCDSAParams;
import com.initech.provider.crypto.interfaces.KCDSAPrivateKey;
import com.initech.provider.crypto.interfaces.KCDSAPublicKey;
import com.initech.provider.crypto.kcdsa.KCDSAPrivateKeyImpl;
import com.initech.provider.crypto.kcdsa.KCDSAPublicKeyImpl;
import com.initech.provider.crypto.spec.KCDSAPrivateKeySpec;
import com.initech.provider.crypto.spec.KCDSAPublicKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KCDSAKeyFactory
extends KeyFactorySpi {
    static Class kcdsaPublicKeySpecClass = KCDSAPublicKeySpec.class;
    static Class kcdsaPrivateKeySpecClass = KCDSAPrivateKeySpec.class;
    static Class x509EncodedKeySpecClass = X509EncodedKeySpec.class;
    static Class pkcs8EncodedKeySpecClass = PKCS8EncodedKeySpec.class;

    protected PrivateKey _engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof KCDSAPrivateKeySpec) {
                KCDSAPrivateKeySpec spec = (KCDSAPrivateKeySpec)keySpec;
                return new KCDSAPrivateKeyImpl(spec.getX(), spec.getY(), spec.getP(), spec.getQ(), spec.getG());
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new KCDSAPrivateKeyImpl(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    protected PublicKey _engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof KCDSAPublicKeySpec) {
                KCDSAPublicKeySpec spec = (KCDSAPublicKeySpec)keySpec;
                return new KCDSAPublicKeyImpl(spec.getY(), spec.getP(), spec.getQ(), spec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new KCDSAPublicKeyImpl(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + e.getMessage());
        }
    }

    protected KeySpec _engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof KCDSAPublicKey) {
            if (kcdsaPublicKeySpecClass.isAssignableFrom(keySpec)) {
                KCDSAPublicKey pubkey = (KCDSAPublicKey)key;
                KCDSAParams params = pubkey.getParams();
                return new KCDSAPublicKeySpec(pubkey.getY(), params.getP(), params.getQ(), params.getG());
            }
            if (x509EncodedKeySpecClass.isAssignableFrom(keySpec)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (key instanceof KCDSAPrivateKey) {
            if (kcdsaPrivateKeySpecClass.isAssignableFrom(keySpec)) {
                KCDSAPrivateKey privkey = (KCDSAPrivateKey)key;
                KCDSAParams params = privkey.getParams();
                return new KCDSAPrivateKeySpec(privkey.getX(), privkey.getY(), params.getP(), params.getQ(), params.getG());
            }
            if (pkcs8EncodedKeySpecClass.isAssignableFrom(keySpec)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        throw new InvalidKeySpecException("Inappropriate key specification");
    }

    protected Key _engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof KCDSAPublicKey) {
                if (key instanceof KCDSAPublicKeyImpl) {
                    return key;
                }
                KCDSAPublicKeySpec keySpec = (KCDSAPublicKeySpec)this._engineGetKeySpec(key, kcdsaPublicKeySpecClass);
                return this._engineGeneratePublic(keySpec);
            }
            if (key instanceof KCDSAPrivateKey) {
                if (key instanceof KCDSAPublicKeyImpl) {
                    return key;
                }
                KCDSAPrivateKeySpec keySpec = (KCDSAPrivateKeySpec)this._engineGetKeySpec(key, kcdsaPublicKeySpecClass);
                return this._engineGeneratePrivate(keySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage());
        }
    }
}

