/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.kcdsa.KCDSAPrivateKeyImpl;
import com.initech.provider.crypto.kcdsa.KCDSAPublicKeyImpl;
import com.initech.provider.crypto.kcdsa.KCDSAUtility;
import com.initech.provider.crypto.md.HAS160;
import com.initech.provider.crypto.spec.KCDSAParameterSpec;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;

public class KCDSAKeyPairGenerator
extends KeyPairGenerator {
    int modlen = 2048;
    boolean genParam;
    SecureRandom random = null;
    BigInteger P = null;
    BigInteger Q = null;
    BigInteger G = null;
    byte[] XKEY = null;
    byte[] OURI = null;
    MessageDigest md = null;
    int mdLen;

    public KCDSAKeyPairGenerator() {
        super("KCDSA");
    }

    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.P == null || this.Q == null || this.G == null || this.genParam) {
            AlgorithmParameterGenerator apg;
            try {
                apg = AlgorithmParameterGenerator.getInstance("KCDSA", InitechProvider.NAME);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Initech Provider is not properly intalled");
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException("Initech Provider is not properly intalled");
            }
            apg.init(this.modlen, this.random);
            try {
                KCDSAParameterSpec spec = apg.generateParameters().getParameterSpec(KCDSAParameterSpec.class);
                this.P = spec.getP();
                this.Q = spec.getQ();
                this.G = spec.getG();
            }
            catch (InvalidParameterSpecException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        try {
            BigInteger X = this.generateX(this.random, this.Q);
            BigInteger Y = this.generateY(this.G, X, this.P, this.Q);
            KCDSAPrivateKeyImpl privkey = new KCDSAPrivateKeyImpl(X, Y, this.P, this.Q, this.G, this.XKEY, this.OURI);
            KCDSAPublicKeyImpl pubkey = new KCDSAPublicKeyImpl(Y, this.P, this.Q, this.G);
            KeyPair kp = new KeyPair(pubkey, privkey);
            this.testPairWiseConsistencyTest(kp);
            return kp;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (DigestException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private BigInteger generateX(SecureRandom random, BigInteger Q) throws DigestException {
        int xLen = Q.bitLength() / 8;
        this.XKEY = new byte[xLen];
        this.OURI = new byte[160];
        byte[] XSEED = new byte[xLen];
        byte[] XVAL = new byte[xLen];
        random.nextBytes(this.XKEY);
        random.nextBytes(this.OURI);
        this.md.reset();
        KCDSAUtility.PRNG(this.OURI, XSEED, Q.bitLength(), this.md);
        BigInteger biXKEY = new BigInteger(1, this.XKEY);
        BigInteger biXSEED = new BigInteger(1, XSEED);
        BigInteger pow2b = new BigInteger(new String("2"));
        BigInteger biXVAL = biXKEY.add(biXSEED).mod(pow2b.pow(Q.bitLength()));
        KCDSAUtility.PRNG(Hex.removeZero(biXVAL.toByteArray()), XVAL, Q.bitLength(), this.md);
        return new BigInteger(1, XVAL).mod(Q);
    }

    private BigInteger generateX(int[] iv, BigInteger Q) {
        int[] u = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        HAS160.processBlock(u, iv);
        int[] X = u;
        byte[] bytesX = new byte[X.length * 4];
        for (int i = 0; i < X.length; ++i) {
            int j = X[i];
            for (int k = 0; k < 4; ++k) {
                bytesX[i * 4 + k] = (byte)(j >>> 24 - k * 8);
            }
        }
        BigInteger ret = new BigInteger(1, bytesX).mod(Q);
        return ret;
    }

    public BigInteger generateY(BigInteger G, BigInteger X, BigInteger P, BigInteger Q) {
        BigInteger x_inv = X.modInverse(Q);
        BigInteger ret = G.modPow(x_inv, P);
        return ret;
    }

    public void initialize(int keysize) {
        this.modlen = keysize;
        this.genParam = true;
        this.random = new SecureRandom();
    }

    public void initialize(int keysize, SecureRandom random) {
        this.modlen = keysize;
        this.genParam = true;
        this.random = random;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof KCDSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.genParam = false;
        KCDSAParameterSpec spec = (KCDSAParameterSpec)params;
        this.P = spec.getP();
        this.Q = spec.getQ();
        this.G = spec.getG();
        String hashName = spec.getHashName();
        try {
            this.md = MessageDigest.getInstance(hashName, InitechProvider.NAME);
            this.mdLen = this.md.getDigestLength();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        this.random = random;
    }

    protected void engineZeroize() {
        if (this.P != null) {
            this.P = BigInteger.ZERO;
        }
        if (this.Q != null) {
            this.Q = BigInteger.ZERO;
        }
        if (this.G != null) {
            this.G = BigInteger.ZERO;
        }
        if (this.XKEY != null) {
            Arrays.fill(this.XKEY, (byte)0);
        }
        if (this.OURI != null) {
            Arrays.fill(this.OURI, (byte)0);
        }
        if (this.random != null) {
            this.random = null;
        }
        if (this.md != null) {
            this.md = null;
        }
    }

    void testPairWiseConsistencyTest(KeyPair keypair) {
        try {
            byte[] msg = "0123456789abcdef".getBytes();
            PublicKey pubkey = keypair.getPublic();
            PrivateKey privkey = keypair.getPrivate();
            Signature sign = Signature.getInstance("SHA256withKCDSA", InitechProvider.NAME);
            sign.initSign(privkey);
            sign.update(msg);
            byte[] signature = sign.sign();
            sign.initVerify(pubkey);
            sign.update(msg);
            if (!sign.verify(signature)) {
                throw new KSXRuntimeException("pair-wise consistency test fail.(sign verify fail)");
            }
        }
        catch (KSXRuntimeException ksxre) {
            throw ksxre;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("Internal Error in pair-wise consistency test", e);
        }
    }
}

