/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.kcdsa.KCDSAUtility;
import com.initech.provider.crypto.spec.KCDSAGenParameterSpec;
import com.initech.provider.crypto.spec.KCDSAParameterSpec;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KCDSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    static BigInteger ONE = BigInteger.valueOf(1L);
    static BigInteger TWO = BigInteger.valueOf(2L);
    int A = 2048;
    int B = 256;
    BigInteger P;
    BigInteger Q;
    BigInteger G;
    BigInteger J;
    BigInteger JJ;
    byte[] seed;
    int count;
    SecureRandom random;
    MessageDigest md = null;

    public KCDSAParameterGenerator() {
        try {
            this.md = MessageDigest.getInstance("SHA256", InitechProvider.NAME);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public KCDSAParameterGenerator(String hashAlg) {
        try {
            this.md = MessageDigest.getInstance(hashAlg, InitechProvider.NAME);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    protected AlgorithmParameters engineGenerateParameters() {
        try {
            this.md.reset();
            this.generatePandQ();
            this.generateG();
            KCDSAParameterSpec s = new KCDSAParameterSpec(this.P, this.Q, this.G, this.J, this.seed, this.count, this.md.getAlgorithm());
            this.P = null;
            this.Q = null;
            this.G = null;
            this.J = null;
            this.seed = null;
            this.count = -1;
            AlgorithmParameters ap = AlgorithmParameters.getInstance("KCDSA", InitechProvider.NAME);
            ap.init(s);
            return ap;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to generate KCDSA parameters");
        }
    }

    public void generatePandQ() throws DigestException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.seed = new byte[this.B / 8];
        byte[] u_ab = new byte[(this.A - this.B) / 8];
        byte[] u_b = new byte[this.B / 8];
        byte[] seed2 = new byte[this.seed.length + 4];
        int cIdx = this.seed.length;
        boolean notFound = true;
        block0: while (notFound) {
            this.random.nextBytes(this.seed);
            KCDSAUtility.PRNG(this.seed, u_ab, this.A - this.B - 4, this.md);
            u_ab[0] = (byte)(u_ab[0] | 0xFFFFFF80);
            int n = u_ab.length - 1;
            u_ab[n] = (byte)(u_ab[n] | 1);
            this.J = new BigInteger(1, u_ab);
            if (!this.J.isProbablePrime(40)) continue;
            this.JJ = this.J.multiply(TWO);
            this.count = 0;
            while (++this.count < 0x1000000) {
                byte[] countBytesTemp = BigInteger.valueOf(this.count).toByteArray();
                byte[] countBytes = new byte[4];
                System.arraycopy(countBytesTemp, 0, countBytes, countBytes.length - countBytesTemp.length, countBytesTemp.length);
                seed2 = new byte[this.seed.length + countBytes.length];
                System.arraycopy(this.seed, 0, seed2, 0, this.seed.length);
                System.arraycopy(countBytes, 0, seed2, this.seed.length, countBytes.length);
                KCDSAUtility.PRNG(seed2, u_b, this.B, this.md);
                u_b[0] = (byte)(u_b[0] | 0xFFFFFF80);
                int n2 = u_b.length - 1;
                u_b[n2] = (byte)(u_b[n2] | 1);
                this.Q = new BigInteger(1, u_b);
                this.P = this.JJ.multiply(this.Q);
                this.P = this.P.add(ONE);
                if (this.P.bitLength() > this.A || !this.Q.isProbablePrime(50) || !this.P.isProbablePrime(50)) continue;
                notFound = false;
                continue block0;
            }
        }
    }

    private BigInteger generateG() {
        BigInteger g = null;
        byte[] a = new byte[this.A / 8 - 1];
        do {
            this.random.nextBytes(a);
            g = new BigInteger(1, a);
            this.G = g.modPow(this.JJ, this.P);
        } while (this.G.equals(ONE));
        return this.G;
    }

    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (genParamSpec instanceof KCDSAGenParameterSpec) {
            this.A = ((KCDSAGenParameterSpec)genParamSpec).getPsize();
            this.B = ((KCDSAGenParameterSpec)genParamSpec).getQsize();
            String hashName = ((KCDSAGenParameterSpec)genParamSpec).getHashAlg();
            if (hashName != null) {
                try {
                    this.md = MessageDigest.getInstance(hashName, InitechProvider.NAME);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
            }
        } else {
            throw new InvalidAlgorithmParameterException("inappropriate parameter specification");
        }
        this.random = random;
    }

    protected void engineInit(int size, SecureRandom random) {
        size = (size + 7 >>> 3) * 8;
        switch (size) {
            case 1024: {
                this.A = 1024;
                this.B = 160;
                break;
            }
            case 2048: {
                this.A = 2048;
                this.B = 256;
                break;
            }
            default: {
                this.A = 2048;
                this.B = 256;
            }
        }
        this.random = random;
    }
}

