/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.cryptox.AlgorithmParametersSpi;
import com.initech.provider.crypto.spec.KCDSAParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class KCDSAParameters
extends AlgorithmParametersSpi {
    protected BigInteger P;
    protected BigInteger Q;
    protected BigInteger G;
    protected BigInteger J;
    protected byte[] seed;
    protected int count;
    protected String hashName = null;

    protected byte[] _engineGetEncoded() throws IOException {
        try {
            DEREncoder enc = new DEREncoder();
            int seq = enc.encodeSequence();
            enc.encodeInteger(this.P);
            enc.encodeInteger(this.Q);
            enc.encodeInteger(this.G);
            if (this.J != null && this.seed != null) {
                enc.encodeInteger(this.J);
                enc.encodeOctetString(this.seed);
                enc.encodeInteger(this.count);
            }
            enc.endOf(seq);
            return enc.toByteArray();
        }
        catch (ASN1Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected byte[] _engineGetEncoded(String s) throws IOException {
        return this._engineGetEncoded();
    }

    protected AlgorithmParameterSpec _engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        try {
            Class<?> paramSpec2 = Class.forName("com.initech.provider.crypto.spec.KCDSAParameterSpec");
            if (paramSpec2.isAssignableFrom(paramSpec)) {
                return new KCDSAParameterSpec(this.P, this.Q, this.G, this.J, this.seed, this.count, this.hashName);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    protected void _engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof KCDSAParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.P = ((KCDSAParameterSpec)paramSpec).getP();
        this.Q = ((KCDSAParameterSpec)paramSpec).getQ();
        this.G = ((KCDSAParameterSpec)paramSpec).getG();
        this.J = ((KCDSAParameterSpec)paramSpec).getJ();
        this.seed = ((KCDSAParameterSpec)paramSpec).getSeed();
        this.count = ((KCDSAParameterSpec)paramSpec).getCount();
        this.hashName = ((KCDSAParameterSpec)paramSpec).getHashName();
    }

    protected void _engineInit(byte[] params) throws IOException {
        try {
            DERDecoder dec = new DERDecoder(params);
            int seq = dec.decodeSequence();
            this.P = dec.decodeInteger();
            this.Q = dec.decodeInteger();
            this.G = dec.decodeInteger();
            if (!dec.endOf(seq)) {
                this.J = dec.decodeInteger();
                dec.decodeSequence();
                this.seed = dec.decodeOctetString();
                this.count = dec.decodeIntegerAsInt();
                dec.endOf(seq);
            }
        }
        catch (ASN1Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected void _engineInit(byte[] params, String s) throws IOException {
        this._engineInit(params);
    }

    protected String _engineToString() {
        return "\n\tp: " + this.P.toString() + "\n\tq: " + this.Q.toString() + "\n\tg: " + this.G.toString() + "\n";
    }
}

