/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.kcdsa;

import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.cryptox.Zeroizable;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.interfaces.KCDSAParams;
import com.initech.provider.crypto.interfaces.KCDSAPrivateKey;
import com.initech.provider.crypto.spec.KCDSAParameterSpec;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;

public final class KCDSAPrivateKeyImpl
implements Zeroizable,
KCDSAPrivateKey {
    private static final long serialVersionUID = 489433017135034986L;
    private BigInteger X;
    private BigInteger Y;
    private KCDSAParameterSpec spec;
    private byte[] XKEY;
    private byte[] OUPRI;
    private PrivateKeyInfo pkinfo = new PrivateKeyInfo();
    private boolean modified = true;

    public KCDSAPrivateKeyImpl() {
    }

    public KCDSAPrivateKeyImpl(BigInteger X, BigInteger Y, BigInteger P, BigInteger Q, BigInteger G) throws InvalidKeyException {
        this.X = X;
        this.Y = Y;
        this.spec = new KCDSAParameterSpec(P, Q, G);
    }

    public KCDSAPrivateKeyImpl(BigInteger X, BigInteger Y, BigInteger P, BigInteger Q, BigInteger G, byte[] XKEY, byte[] OUPRI) throws InvalidKeyException {
        this.X = X;
        this.Y = Y;
        this.spec = new KCDSAParameterSpec(P, Q, G);
        this.XKEY = XKEY;
        this.OUPRI = OUPRI;
    }

    public KCDSAPrivateKeyImpl(byte[] privkey) throws InvalidKeyException {
        try {
            this.pkinfo = new PrivateKeyInfo(privkey);
            if (!this.pkinfo.getAlgorithm().equals("1.2.410.200004.1.21")) {
                throw new InvalidKeyException("this algorithm is not KCDSA");
            }
            AlgorithmParameters ap = AlgorithmParameters.getInstance("KCDSA", InitechProvider.NAME);
            ap.init(this.pkinfo.getParameters());
            this.spec = ap.getParameterSpec(KCDSAParameterSpec.class);
            DERDecoder dec = new DERDecoder(this.pkinfo.getPrivateKey());
            try {
                int seq = dec.decodeSequence();
                this.X = dec.decodeInteger();
                this.Y = dec.decodeInteger();
                dec.endOf(seq);
            }
            catch (Exception e) {
                if (this.X == null) {
                    dec = new DERDecoder(this.pkinfo.getPrivateKey());
                    this.X = dec.decodeInteger();
                    this.Y = this.generateY(this.spec.getG(), this.X, this.spec.getP(), this.spec.getQ());
                }
                if (this.Y == null) {
                    this.Y = this.generateY(this.spec.getG(), this.X, this.spec.getP(), this.spec.getQ());
                }
                throw e;
            }
            this.modified = true;
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public BigInteger generateY(BigInteger G, BigInteger X, BigInteger P, BigInteger Q) {
        BigInteger x_inv = X.modInverse(Q);
        BigInteger ret = G.modPow(x_inv, P);
        return ret;
    }

    public KCDSAParams getParams() {
        return this.spec;
    }

    public BigInteger getX() {
        return this.X;
    }

    public BigInteger getY() {
        return this.Y;
    }

    public byte[] getXKEY() {
        return this.XKEY;
    }

    public byte[] getOUPRI() {
        return this.OUPRI;
    }

    public String getAlgorithm() {
        return "KCDSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            if (!this.modified) {
                return this.pkinfo.getEncoded();
            }
            AlgorithmParameters param = AlgorithmParameters.getInstance("KCDSA", InitechProvider.NAME);
            param.init(this.spec);
            this.pkinfo.setPrivateKeyAlgorithm(new AlgorithmID("1.2.410.200004.1.21", param.getEncoded()));
            DEREncoder enc = new DEREncoder();
            int seq = enc.encodeSequence();
            enc.encodeInteger(this.X);
            enc.encodeInteger(this.Y);
            enc.endOf(seq);
            byte[] key = enc.toByteArray();
            this.pkinfo.setPrivateKey(key);
            byte[] ret = this.pkinfo.getEncoded();
            this.modified = false;
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void zeroize() {
        if (this.X != null) {
            this.X = BigInteger.ZERO;
        }
        if (this.Y != null) {
            this.Y = BigInteger.ZERO;
        }
        this.modified = true;
    }
}

